
#
# mosaic.cl 
#
# iraf script to combine offset ifu images
#
# A. J. Dean 9th Aug, 2002
#
# Format of offset file is x_offset y_offset
# The offset is the lens coordinates in the new IFU image of a 
# reference object relative to its position in the first IFU image 
# in the list
#
# Modified A. J. Dean 1st July, 2003 to also properly populate
# the variance arrays
#
# This version also has strange verb+ and >& "dev$null" and flpr
# to work around PC-IRAF V2.12 bug

procedure mosaic(ifuimagefile, offset_file, output_file)

string ifuimagefile {prompt="File list of input ifuimages"}
string offset_file  {prompt="File containing the list of offsets"}
string output_file  {prompt="Output ms file"}
bool   overw        {mode="l", prompt="overwrite output file?"}

struct *in {mode="h"}

begin

string ifuimfile, offsetfile, outfile
string ifuimages[500]
string tempstring, inlist, varlist, poslist, tempspec, lenslist, tempms
string tempvarms
string ifuconfigfile
string dispaxis, dcflag, wcsdim, cytpe1, ctype2, crval1, crval2, crpix1
string crpix2, cdelt1, cdelt2, cd1_1, cd2_2, ltm1_1, ltm2_2, wat0_001
string wat1_001, wat2_001
#string tempscopy

int x[500], y[500]
int tempx, tempy, templens, tempap

int lens[5000], gridx[5000], gridy[5000], apnum[5000]
int mingridx, maxgridx
int mingridy, maxgridy

int maxoffx, minoffx
int maxoffy, minoffy

int num, numlens, lenscount

int newgridminx, newgridmaxx
int newgridminy, newgridmaxy

int lensx, lensy, spectrum
int specdim, len
int i, j, k, h, count

int nextend

bool gotalens, exist, over

#***** Load necessary packages
if (!defpac ("stsdas")) {
	stsdas(motd-)
}

tables
fitsutil
utils


#***** Stuff that's used a lot
cache("scombine","imcopy")

#***** So you don't forget!
print("")
print("******** epar scombine to tune it as desired *********")
print("***** dispaxis for scopy needs to be correct too *****")
print("")

#***** Query parameters
ifuimfile=ifuimagefile
offsetfile=offset_file
outfile=output_file

# check for .fits on the end of filenames
len=strlen(outfile)
if(substr(outfile,len-4,len)!=".fits") {
	outfile=outfile//".fits"
}

# check for existence of files

exist=access(ifuimfile)
if(!exist){
                print("Image list file ", ifuimfile," does not exist!")
                bye

}

exist=access(offsetfile)
if(!exist){
                print("Offset list file ", offsetfile," does not exist!")
                bye

}

# check if output file already exists
exist=access(outfile)
if(exist){
                print("!!!!! output file ", outfile," exists !!!!!")
                over=overw
                if(over){
                        delete(outfile)
                } else {
                        print("You should probably pick a different output file name!")
                        bye
                }
}

#***** Read in the ifu image file
in=ifuimfile
i=1
while(fscan(in,tempstring)!=EOF){
	# check for .fits on the end of filenames
	len=strlen(tempstring)
	if(substr(tempstring,len-4,len)!=".fits") {
	tempstring=tempstring//".fits"
	}
	ifuimages[i]=tempstring
#	print("Got image",tempstring)
	i+=1
	if(i>500){
		error(11,"You have more than 500 IFU images!\nArray for IFU images has run out of room!")
	}
}

num=i-1
print("Number of ifuimages to combine is ",num)

#***** Read in the offsets
in=offsetfile
i=1
while(fscan(in,tempx,tempy)!=EOF){
	x[i]=tempx
	y[i]=tempy
	print("Got offset ",x[i],y[i])
	i+=1
	if(i>500){
		error(11,"You have more than 500 offset points but not that many ifu images!\nArray for offsets has run out of room!")
	}
}

if(num!=(i-1)){
	error(11,"List of images and list of offsets do not have the same number of points!")
}

#***** Read in the ifu configuration
#***** Assume table information in first image is the same as the rest of
#***** the list!
ifuconfigfile=mktemp("__ifuconfigfile__")
tprint(ifuimages[1]//"[1]",prparam-,prdata+,pwidth=80,plength=0,showrow-,
	orig_row-,showhdr-,columns="",rows="",option="plain",align-,
	sp_col="",lgroup=0,>ifuconfigfile)

in=ifuconfigfile
i=1
while(fscan(in,templens,tempx,tempy,tempap)!=EOF){
	if(tempx!=-999){
		lens[i]=templens
		gridx[i]=tempx
		gridy[i]=tempy
		apnum[i]=tempap
#		print("Got lens grid and ap ",lens[i],gridx[i],gridy[i],
#		       apnum[i])

# Spectra we want the software to ignore -> bad bits of the ifu
                if( (lens[i]==336) || (lens[i]==337) ){
                        apnum[i]=-999
                }

		i+=1
		if(i>5000){
			error(11,"You have more than 5000 lenses in 1 IFU\nArray for lenses has run out of room!")
		}
	}
}

numlens=i-1

#***** Find out the size of the grid
mingridx=gridx[1]
maxgridx=gridx[1]
mingridy=gridy[1]
maxgridy=gridy[1]

for(i=1; i<=numlens; i+=1){
	if(gridx[i]<mingridx){
		mingridx=gridx[i]
	}
	if(gridx[i]>maxgridx){
		maxgridx=gridx[i]
	}
	if(gridy[i]<mingridy){
		mingridy=gridy[i]
	}
	if(gridy[i]>maxgridy){
		maxgridy=gridy[i]
	}
}

print("IFU grid size is: ",mingridx,"< x < ",maxgridx," ",
 	mingridy,"< y < ",maxgridy)

#***** Find out the extent of the offsetting
maxoffx=x[1]
minoffx=x[1]
maxoffy=y[1]
minoffy=y[1]

for(i=1; i<=num; i+=1){
	if(x[i]<minoffx){
		minoffx=x[i]
	}
	if(x[i]>maxoffx){
		maxoffx=x[i]
	}
	if(y[i]<minoffy){
		minoffy=y[i]
 	}
	if(y[i]>maxoffy){
		maxoffy=y[i]
	}
}

if(minoffx>0){
	minoffx=0
}

if(minoffy>0){
	minoffy=0
}

if(maxoffx<0){
	maxoffx=0
}

if(maxoffy<0){
	maxoffy=0
}

print("Max offsets are: ",minoffx,"x ",maxoffx, " ",
 	minoffy, "y ", maxoffy)

#***** Calculate the size of the new grid
newgridminx=mingridx-maxoffx
newgridmaxx=maxgridx-minoffx

newgridminy=mingridy-maxoffy
newgridmaxy=maxgridy-minoffy

print("New grid size is ",newgridminx,"< x < ",newgridmaxx," ",
 	newgridminy,"< y < ",newgridmaxy)

#***** Loop over the grid and add up the lenses
#***** Do this the easy way for a human to understand
#***** which is computationally bad!
lenscount=1
inlist=mktemp("__filelist__")
varlist=mktemp("__varlist__")
tempspec=mktemp("__tempspec__")
poslist=mktemp("__poslist__")
lenslist=mktemp("__lenslist__")
#tempscopy=mktemp("__scopy__")

print("scombining the spectra, this could take a while!")

for(i=newgridminx; i<=newgridmaxx; i+=1){

	for(j=newgridminy; j<=newgridmaxy; j+=1){

		gotalens=no
		
		count=0

		for(k=1; k<=num; k+=1){

			#***** Figure out which lenses to copy out
			lensx=i+x[k]
			lensy=j+y[k]
			
			#***** Find the spectrum corresponding 
			#***** to the lens in the IFU
			spectrum=-999
			
			for(h=1; h<=numlens; h+=1){

				if( (gridx[h]==lensx) && (gridy[h]==lensy)){
					
					spectrum=apnum[h]
					break
				
				}
			
			}
			
			if(spectrum!=-999){
	
# Attempt to fix random scopy behaviour that didn't work!
			        #scopy(ifuimages[k]//"[sci,1]", tempscopy//count, apertures=spectrum,verb+)

				#print(tempscopy//count,>>inlist)

				print(ifuimages[k]//"[sci,1][*,"//spectrum//"]", >>inlist)
				print(ifuimages[k]//"[var,1][*,"//spectrum//"]", >>varlist)
					gotalens=yes
					count+=1
			}
		}
		
		if(gotalens){
	
			scombine("@"//inlist, 
				 output=tempspec//"_lens_"//lenscount,
                                 group="all", combine="average",
				 >& "dev$null")
			flpr("scombine")
			scombine("@"//varlist, 
				 output=tempspec//"_var_lens_"//lenscount,
                                 group="all", combine="sum",
				 >& "dev$null")
			flpr("scombine")
			sarith(tempspec//"_var_lens_"//lenscount, "/",
				(count*count),
				output=tempspec//"_var_lens_"//lenscount,
				clobber+, merge-, verb+, >& "dev$null")
			# PC-IRAF V2.12 bug fix, need to flpr scombine
			print(lenscount,i,j,lenscount,>>poslist)
			print(tempspec//"_lens_"//lenscount,>>lenslist)
			lenscount+=1
                        #imdelete("@"//inlist)
			delete(inlist)
			delete(varlist)
			
		}

	}

print("Done column ",i,"of the mosaic")

}

lenscount-=1

#***** Make a temporary ms file
tempms=mktemp("__tempms__")
tempms=tempms//"ms.fits"
tempvarms=mktemp("__tempvarms__")
tempvarms=tempvarms//"ms.fits"

print("Making ",outfile)

# setting offset=0 here, causes the cl to print ambiguous parameter!!!!!
# This approach messes up the headers!!!!!!
#scopy("@"//lenslist, tempms, apertures="", bands="", beams="", apmodulus=0, 
#	format="multispec", renum+, clobber-, merge-, rebin+, verb-)
# back to the first approach .....

#scopy.offset=-1
#scopy("@"//lenslist, "ajd_test.ms", w1=INDEF, w2=INDEF, apertures="", 
#	bands="", beams="", apmodulus=0, format="multispec", renum+, 
#	clobber+, merge+, rebin+, verb-)

imgets(ifuimages//"[sci,1]", "i_naxis1")
specdim = int(imgets.value)

mkpattern(tempms,output="",pattern="constant",ndim=2,ncols=specdim,
	  nlines=lenscount)

mkpattern(tempvarms,output="",pattern="constant",ndim=2,ncols=specdim,
	  nlines=lenscount)

print("Combined the spectra, making the ms file")
for(i=1; i<=lenscount; i+=1){
	imcopy(tempspec//"_lens_"//i,tempms//"[*,"//i//"]",verb-)
	imcopy(tempspec//"_var_lens_"//i,tempvarms//"[*,"//i//"]",verb-)
#	scopy(tempspec//"_lens_"//i,"ajdtest.ms",merge+,renum+,clobber+)
}

#***** Copy the wavelength solution back over if it exists

dispaxis="NOTSET"
hselect(ifuimages[1]//"[sci,1]","DISPAXIS",yes) | scan(dispaxis)
if(dispaxis=="1"){
	print("Updating wavelength solution with that from ",
	      ifuimages[1]//"[sci,1]")
	dcflag="NOTSET"
	wcsdim="NOTSET" 
	cytpe1="NOTSET" 
	ctype2="NOTSET" 
	crval1="NOTSET"
	crval2="NOTSET"
	crpix1="NOTSET" 
	crpix2="NOTSET" 
	cdelt1="NOTSET" 
	cdelt2="NOTSET" 
	cd1_1="NOTSET" 
	cd2_2="NOTSET" 
	ltm1_1="NOTSET" 
	ltm2_2="NOTSET"  
	wat0_00="NOTSET"
	wat1_001="NOTSET"
	wat2_001="NOTSET"

	hselect(ifuimages[1]//"[sci,1]","DC-FLAG",yes) | scan(dcflag)
	hselect(ifuimages[1]//"[sci,1]","WCSDIM",yes) | scan(wcsdim)  
	hselect(ifuimages[1]//"[sci,1]","CYTPE1",yes) | scan(cytpe1) 
	hselect(ifuimages[1]//"[sci,1]","CTYPE2",yes) | scan(ctype2) 
	hselect(ifuimages[1]//"[sci,1]","CRVAL1",yes) | scan(crval1)  
	hselect(ifuimages[1]//"[sci,1]","CRVAL2",yes) | scan(crval2)  
	hselect(ifuimages[1]//"[sci,1]","CRPIX1",yes) | scan(crpix1)  
	hselect(ifuimages[1]//"[sci,1]","CRPIX2",yes) | scan(crpix2)  
	hselect(ifuimages[1]//"[sci,1]","CDELT1",yes) | scan(cdelt1)  
	hselect(ifuimages[1]//"[sci,1]","CDELT2",yes) | scan(cdelt2)  
	hselect(ifuimages[1]//"[sci,1]","CD1_1",yes) | scan(cd1_1)   
	hselect(ifuimages[1]//"[sci,1]","CD2_2",yes) | scan(cd2_2)  
	hselect(ifuimages[1]//"[sci,1]","LTM1_1",yes) | scan(ltm1_1)  
	hselect(ifuimages[1]//"[sci,1]","LTM2_2",yes) | scan(ltm2_2)  
	hselect(ifuimages[1]//"[sci,1]","WAT0_001",yes) | scan(wat0_001)
	hselect(ifuimages[1]//"[sci,1]","WAT1_001",yes) | scan(wat1_001)
	hselect(ifuimages[1]//"[sci,1]","WAT2_001",yes) | scan(wat2_001)

	hedit(tempms,fields="DISPAXIS",value=dispaxis, add+, ver-, show-)
	hedit(tempms,fields="DC-FLAG",value=dcflag, add+, ver-, show-)
	hedit(tempms,fields="WCSDIM",value=wcsdim, add+, ver-, show-)  
	hedit(tempms,fields="CYTPE1",value=cytpe1, add+, ver-, show-)   
	hedit(tempms,fields="CTYPE2",value=ctype2, add+, ver-, show-)   
	hedit(tempms,fields="CRVAL1",value=crval1, add+, ver-, show-)   
	hedit(tempms,fields="CRVAL2",value=crval2, add+, ver-, show-)   
	hedit(tempms,fields="CRPIX1",value=crpix1, add+, ver-, show-)   
	hedit(tempms,fields="CRPIX2",value=crpix2, add+, ver-, show-)   
	hedit(tempms,fields="CDELT1",value=cdelt1, add+, ver-, show-)   
	hedit(tempms,fields="CDELT2",value=cdelt2, add+, ver-, show-)   
	hedit(tempms,fields="CD1_1",value= cd1_1, add+, ver-, show-)    
	hedit(tempms,fields="CD2_2",value= cd2_2, add+, ver-, show-)    
	hedit(tempms,fields="LTM1_1",value=ltm1_1, add+, ver-, show-)   
	hedit(tempms,fields="LTM2_2",value=ltm2_2, add+, ver-, show-)   
	hedit(tempms,fields="WAT0_001",value=wat0_001, add+, ver-, show-)
	hedit(tempms,fields="WAT1_001",value=wat1_001, add+, ver-, show-)
	hedit(tempms,fields="WAT2_001",value=wat2_001, add+, ver-, show-)

} else {
	# Do nothing
	# print("Data is not wavelength corrected")
}

#***** Copy over the spectra into the output file

#***** The cheap and nasty solution again

#***** You really should fix this section !!!!!

makemef3(ifuimages[1],tempms, outfile)
fxdelete(outfile,groups="1",verb-)

#***** Reduce nextend by 1 as have removed an extension
nextend=0
hselect(outfile//"[0]","NEXTEND",yes) | scan(nextend)
nextend=nextend-1
hedit(outfile//"[0]",fields="NEXTEND", value=nextend, add-, update+, ver-, show-)

# insert_table knows our lenses are hexagons !!!!!
insert_table(outfile,poslist) 

#makemef2(ifuimages[1],"ajd_test.ms.fits","ajd_test_wav.ms.fits")
#fxdelete("ajd_test_wav.ms.fits",groups="1",verb-)
#insert_table("ajd_test_wav.ms.fits",poslist) 

overwrite_ext(outfile,tempvarms,"var","1", >& "dev$null")

#***** Clean up
delete(tempspec//"_lens_*")
delete(tempspec//"_var_lens_*")
delete(ifuconfigfile)
delete(poslist)
delete(lenslist)
delete(tempms)
delete(tempvarms)

end










