procedure findpos_auto(name,posfile,outfile,initpos,in_minsep,in_numcalfib)

#############################################################################
# 20/6/01 RAJ
# task to use the calibration fibre image + a file containing the
# relative positions of all the fibres to find the actual positions
# of all the fibres. the user marks a subset of the calibration fibres
# on the image and the program fits a Gaussian to each one to find
# more accurate centres. the program then finds the position of
# each of the calibration fibres in the relative positions file and
# uses this and the centred position to find the average shift between
# the actual and relative position of the calibration fibres. 
# this shift is then added on the relative position for all the 
# fibres to give the actual position for each fibre.

############
# 4/9/01 AJD
# Automated so that cal fibres are found automatically

string name {prompt="Name of calibration fibre image"}
string posfile {prompt="Name of file containing relative position information"}
string outfile {prompt="Name of file to contain the output fibre positions"}
string initpos {prompt="Fibre number of the first separate calibration fibre on detector?"}
int in_line    {prompt="Line to use as cut through image"}
int in_noise   {prompt="background noise in image"}
int in_sigma   {prompt="sigma above background which indicates a line"}
int in_minsep  {prompt="Minimum separation between fibres"}
int in_numcalfib  {5, prompt="Number of well separated calibration fibres"}

struct *in {mode="h"}

begin

string p_name, p_posfile, p_outfile, tempfile, tempfile1, logfile, tempstr
struct tempstruct
string therest[508]
real junk, y, dist, pitch, avpitch, tempreal, r1, r2, fwhmreal
int i, num, p_initpos, number, j, avnum, numcen
int fibnum[0:7]=7,23,55,96,122,172,312,424
int numcalfib
int fibstart, fibend
int line,noise,sigma,minsep,len
real avshift
real fibpos[0:50]=51(0)
real ypos[0:50]
real pos[508]
real fwhm[0:50]=51(0)
real yrel[508]

p_name=name
p_posfile=posfile
p_initpos=int(initpos)
p_outfile=outfile

line=in_line  
noise=in_noise  
sigma=in_sigma  
minsep=in_minsep
numcalfib=in_numcalfib

##load required packages
utils

tempfile=mktemp("temp")
tempfile1=mktemp("temp")
logfile=mktemp("log")

# check for .fits on the end

        len=strlen(p_name)
        if(substr(p_name,len-4,len)!=".fits") {
                p_name=p_name//".fits"
        }

peakfind_sep(p_name,line,noise,sigma,tempfile,minsep)

#display (p_name, 1, bpmask="BPM", bpdisplay="none", bpcolors="red", overlay="", ocolors="green", erase=yes, border_erase=no, select_frame=yes, repeat=no, fill=no, zscale=yes, contrast=0.25, zrange=yes, zmask="", nsample=1000, xcenter=0.5, ycenter=0.5, xsize=1., ysize=1., xmag=1., ymag=1., order=0, z1=0., z2=0., ztrans="linear", lutfile="")

#print("Please mark the y positions of the calibration fibres. \nPress any key, ^D to finish");
#print("Only mark whichever of the following fibres fall on the detector")
#for(i=0;i<numcalfib;i+=1){
#  print(fibnum[i])
#}

#rimcursor(p_name,wcs="logical",wxformat="",wyformat="",>tempfile)

#fitprofs just needs the y coordinate so get this out of tempfile and
#put into tempfile1
in=tempfile
i=0
#while(fscan(in,junk,y,junk,junk)!=EOF){
while(fscan(in,y)!=EOF){
  ypos[i]=y
  print("i ",i,"marked position ",ypos[i])
  i+=1
}
num=i

#check we found the fibres we expected
if(num!=numcalfib){
	print("Did not find as many calibration fibres as expected!")
	print("The program expects to find calibration fibres")
	print("7,23,55,96,122,172,312,424"
	print("with the start / end being flexible but not the middle fibres")
	print("Please check fibre locating parameters using locatepeaks_sep (noise and sigma)")
	print("and adjust the inputs to this task appropriately.")
	bye
} 

print("")
print("Fitting Gaussians using fitprofs")

#fit gaussians for each marked position. have to do this for each one 
#separately as sometimes it doesn't work if try to fit them all
#at the same time
for(i=0;i<num;i+=1){
  tempfile1=mktemp("temp")
  logfile=mktemp("log")
  print(ypos[i],>tempfile1)
  r1=ypos[i]-10
  r2=ypos[i]+10
  tempstr=r1//" "//r2
  print("position ",ypos[i]," region ",tempstr) 
  fitprofs (p_name//"[sci,1]", lines="512", bands="", dispaxis=2, nsum="10", region=tempstr, positions=tempfile1, background="", profile="gaussian", gfwhm=2., lfwhm=2., fitbackgroun=yes, fitpositions="all", fitgfwhm="all", fitlfwhm="all", nerrsample=0, sigma0=INDEF, invgain=INDEF, components="", verbose=no, logfile=logfile, plotfile="", output="", option="fit", clobber=no, merge=no)
  delete(tempfile1)

#pull out the centre positions which is the first column in logfile
#and put into array fibpos
  in=logfile
  while(fscan(in,tempstr,junk,junk,junk,junk,fwhmreal)!=EOF){
    if(tempstr!="#"){
      fibpos[i]=real(tempstr)
      fwhm[i]=fwhmreal
    }
  }
  delete(logfile)
}
numcen=i

#find which calibration fibres fall on the detector
fibstart=0
for(i=0;i<numcalfib;i+=1){
  if(fibnum[i]<p_initpos)
    fibstart+=1
}

#take into account any fibres falling off the top end of the detector
#by looking at the number of centred positions and making this=fibend
fibend = numcen + fibstart

#read in the file containing the relative fibre positions on the detector
#work out the average shift between the relative fibre positions in this
#file and the centred positions of the calibration fibres
#add this shift to all the relative fibre positions to get the
#actual fibre positions.

in=p_posfile
i=1
while(fscan(in,tempreal,tempstruct)!=EOF){
  yrel[i]=tempreal
  therest[i]=tempstruct
  i+=1
}
num=i
print("fibstart ",fibstart," fibend ",fibend)

avshift=0
for(i=fibstart;i<fibend;i+=1){
  print("fibre ",fibnum[i]," centred pos ",fibpos[i-fibstart]," relative pos ",yrel[fibnum[i]], "diff ",fibpos[i-fibstart]-yrel[fibnum[i]])
  avshift=avshift+fibpos[i-fibstart]-yrel[fibnum[i]]
}

avshift=avshift/(fibend-fibstart)

print("")
print("average shift between calibration fibre position and relative position is ",avshift)

print("")
print("Creating output file ",p_outfile)

for(i=1;i<num;i+=1){
  pos[i]=yrel[i]+avshift
#  print(pos[i],therest[i]," ",pos[i])
  print(pos[i],therest[i]," ",>>p_outfile)
}

delete(tempfile)

end






