# IRAF script -- coscirp.cl
#
#	Andrew Bunker, Institute of Astronomy, Cambridge
#	Tue Aug 20 11:47:35 BST 2002
#
#   function: to reject cosmics in CIRPASS using multiple non-destructive reads
#
# Modified by AJD to work with MEF files, and so that you don't need
# to epar imcombine as well.

procedure coscirp(inlist)

string  inlist          {prompt="Input ima image?"}
string  outimage        {"cr",prompt="Prefix for output image?"}
string  rej		{"crrej",prompt="imcomb rejection (crrej, ccdclip)?"}
real    snoise		{0.2,prompt="imcomb sensitivity noise?"}
bool	docomb	   {yes, prompt="Combine the images?"}
bool    doscale    {yes, prompt="Scale to total exp time?"}
string  zero       {"none", prompt="imcombine: zero"}
string  statsec    {"", prompt="imcombine: statsec"}
real    lsigma     {3, prompt="imcombine: lsigma"}
real 	hsigma     {3, prompt="imcombine: hsigma"}
real    rdnoise    {17, prompt="imcombine: rdnoise"}
real    gain       {7, prompt="imcombine: gain"}


struct  *inimglist
struct  *incomblist

begin
        string  inl, inimages, incomb
	string p_outimage, p_rej, p_snoise
	bool p_docomb, p_doscale
	int loop, len
	string imc_zero, imc_statsec
	real imc_lsigma, imc_hsigma, imc_rdnoise, imc_gain

# Expand file lists into temporary files.

        inimages = mktemp("tmp$coscirp")
        sections (inlist,option="fullname",>inimages)
        inimglist = inimages

# Read in the query parameters - something not in the original script!

	p_outimage=outimage
	p_rej=rej
	p_snoise=snoise
	p_docomb=docomb
	p_doscale=doscale
	imc_zero=zero
	imc_statsec=statsec
	imc_lsigma=lsigma
   	imc_hsigma=hsigma
	imc_rdnoise=rdnoise 
	imc_gain=gain

# Loop through input files:

        while (fscan(inimglist,inl) != EOF) {
	
	# check for .fits on the end ** AJD change **
        len=strlen(inl)
        if(substr(inl,len-4,len)==".fits") {
                inl=substr(inl,1,len-5)
        }

        incomb = mktemp("tmp$coscirpls")


	imgets(inl//"[0]","NLOOPS")
	loop=int(imgets.value)

	for(i=1;i<=loop;i+=1){
	  imarith(inl//"[SCI,"//i//"]","-",inl//"[SCI,"//i+1//"]",inl//i//"_tmp")
        sections (inl//i//"_tmp",option="fullname",>>incomb)

	  }

	  incomblist=incomb

	if (p_docomb == 1) {
	print("combining loops and rejecting cosmics")
	## print("### REMEMBER to epar imcombine ###")
	## print("to set lsigma,hsigma,rdnoise,gain")
	
	print("REMEMBER to set lsigma,hsigma,rdnoise,gain appropriately")

	imcombine("@"//incomb,inl//p_outimage//"_tmp",
                  rejmask=inl//p_outimage//"_rej", reject=p_rej,
	          snoise=p_snoise, lsigma=imc_lsigma, hsigma=imc_hsigma,
		  zero=imc_zero, statsec=imc_statsec,
		  rdnoise=imc_rdnoise, gain=imc_gain)
	
	if (p_doscale == 1) {
	   imarith(inl//p_outimage//"_tmp","*",loop,inl//p_outimage//"_tmp")
	   }
	
# Overwrite input file and make a mef with only 4 extensions ** AJD change **
	makemef(inl//".fits",inl//p_outimage//"_tmp.fits",p_outimage//".fits")


#	copy(inl//".fits",p_outimage//inl//".fits")
#	imcopy("tmp_"//p_outimage//inl//"[*,*]",p_outimage//inl//"[sci,1][*,*]",
#		ver-)
	
	delete(inl//".fits")
	copy(p_outimage//".fits", inl//".fits",verbose+)
	delete(p_outimage//".fits")

	# Clean up
        imdel(inl//"*_tmp.fits",ver-)
#      imdel(inl//p_outimage//"_tmp",ver-)

	}
	}

# This command will attempt to delete files owned by other users in tmp, 
# who've run coscirp and then its crashed, so it will print error messages
# to the screen
#	del("tmp$coscirp*",ver-)

	del(incomb,ver-)

end







