# beam_switch.cl quick script to imarith sci,1 extensions 
# and display the result
#
# A. J. Dean. 11th Aug, 2002

procedure sub(image1,image2)

string image1 {prompt="1st run number"}
string image2 {prompt="2nd run number"}
int displayframe {1,prompt="frame to display result in"}

begin

	string im1,im2
	string file1, file2, outim
	int dispframe

	im1=image1
	im2=image2

	file1="notset"
	file2="notset"

	files("*_"//im1//"_ima.fits") | scan (file1)
	files("*_"//im2//"_ima.fits") | scan (file2)
	
	if(file1=="notset"){
		print("Could not find a file with run number ",im1)
		bye
	}
	
	if(file2=="notset"){
		print("Could not find a file with run number ",im2)
		bye
	}

	outim=im1//"-"//im2//"_ima.fits"

	print("Doing ", file1, " - ", file2, " to ", outim)

	dispframe=displayframe

	mefarith(file1,"-",file2,outim)

	display(outim//"[sci,1]",dispframe)

end


