#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>

/*#define SERV_ADDR "192.168.2.3"*/
/*#define SERV_ADDR "131.111.68.66"*/ /* Cirpass 3 on IoA network */
/*#define SERV_ADDR "161.72.6.44"*/
#define SERV_ADDR "192.168.2.3" /* Cirpass 3 */
#define PORT 16421

int main( int argc, char *argv[] )
{

	int sockfd;
	struct sockaddr_in serv_addr;
	char prompt[81]={0};
	fd_set readfds;
	int got=0;

	/* check args */
	if ( argc != 2) {
		fprintf(stderr,"Usage: %s string\n",argv[0]);
		exit(1);
	}

	/* Fill in socket struct */
	memset(&serv_addr,0,sizeof(serv_addr));
	serv_addr.sin_family 	  = AF_INET;
	serv_addr.sin_addr.s_addr = inet_addr(SERV_ADDR);
	serv_addr.sin_port 	  = htons(PORT);

	/*printf("Opening socket\n");*/
	/* Open socket */
	if (  (sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0 ) {
		perror("Can't open socket");
		exit(1);
	}

	/*printf("Connecting to server\n");*/
	/* Connect to server */
	if (connect(sockfd,(struct sockaddr*)&serv_addr,
		    sizeof(serv_addr))<0) {
		perror("Can't connect to server");
		exit(1);
	}
		
        /*printf("Reading input from server\n");*/
	/* Read input from server, to flush input buffer */
	/* recv(sockfd,prompt,80,0); */
	
	/*printf("sending argv1\n");*/
	/* Send argv1 = use read to read from socket */
	if (write(sockfd,argv[1],strlen(argv[1])) != strlen(argv[1])) {
		perror("Can't write to server");
		exit(1);
	}
	
	/*printf("waiting for prompt\n");*/

	/* clear the file descriptor, and add the read socket to it */

	FD_ZERO(&readfds);
	FD_SET(sockfd, &readfds);

	if ( !strncmp(argv[1],"g",1 ) ){   /* User issued go */
	 
	  /* Wait for ready prompt back */	
	  do{
	    
	    while ( select(sockfd+1,&readfds, NULL, NULL, NULL) != 1);
	       
	    if (FD_ISSET(sockfd, &readfds)){
	      got=recv(sockfd,prompt,80,0);
	    } else {
	      printf("Socket claims to be ready but has no data!\n");
	      exit(1);
	    }	
	    
	    prompt[got]='\0';
	    printf("%s",prompt);
	    
	  } while( strncmp(prompt,"READY",5)!=0 );
	  
	} else {
	  
	  /* wait for any prompt back */
	  while ( !recv(sockfd,prompt,80,0) ) {
	    /* wait */ 
	  }
	  
	}

	/* Fix as otherwise PixCel decides to stop accepting connections */
	write(sockfd,"exit",4);
		
	/* printf("closing socket\n"); */
	/* Close socket */
	close(sockfd);
	
	/* If OK dont write prompt */
	if ( !strncmp(prompt,"OK",2) ) {
		return(EXIT_SUCCESS);
	}
	if ( !strncmp(prompt,"WAIT",4) ) {
		return(EXIT_SUCCESS);
	}

	/* If Error dont write prompt */
	if ( !strncmp(prompt,"ERROR",5) ) {
		return(EXIT_FAILURE);
	}

	/* Else write prompt */
	printf("%s",prompt);
	return(EXIT_SUCCESS);

}

