# wvcal.cl
#
# iraf script to make a wavelength calibrated cal.ms file
#
# A. J. Dean, 5th Aug, 2002

procedure wvcal(filein, ref, fileout)

string filein    {prompt="File to dispersion correct"}
string ref	 {prompt="Wavelength calibrated cal.ms file"}
string fileout   {prompt="Output wavelength calibrated file"}

begin

string reffile, inputfile, outfile, tempfile
int len

inputfile=filein
reffile=ref
outfile=fileout

# check for .fits on the end of filenames
	len=strlen(inputfile)
        if(substr(inputfile,len-4,len)!=".fits") {
                inputfile=inputfile//".fits"
        }
	len=strlen(outfile)
        if(substr(outfile,len-4,len)!=".fits") {
                outfile=outfile//".fits"
        }

tempfile=mktemp("__temp__")
tempfile=tempfile//".ms.fits"

refspec(inputfile//"[sci,1]", reference=reffile//"[sci,1]", aperture="",
	 refaps="", ignore-, select="nearest", sort="",group="", over+, 
	 confirm-, assign+)

dispc(inputfile//"[sci,1]",tempfile, lin+, flux-, samedisp-, global-, ignor-, 
      confirm-, list-, ver+)

makemef2(inputfile, tempfile, outfile)

delete(tempfile)

end

