/* C program to make a readnoise estimate from a cirpass _raw or _ima file
** 
** AJ Dean, 1st May, 2001
**
*/

#include <stdlib.h>
#include <math.h>
#include "fitswrap.h"
#include "nrroutines.h"

int main(int argc, char* argv[])
{

  float* data;
  float x[200]={0};
  float y[200]={0};
  int nextend=0;
  long axes[3]={0};
  int nsci=0;
  int nread=0;
  int nbytes=0;
  int i=0;
  int j=0;
  int k=0;
  float* sqsum=NULL;
  float* rms=NULL;
  float average=0;
  float gain=0;
  int box=0;

  float a, b, siga, sigb, chi2, q;
  float sig[200]={0};
  int mwt=0;

  int status=0;                        /* Error handle for cfitsio */
  fitsfile *fptr;                      /* fits object as defined by cfitsio */


  /* Check for appropriate input */
  if (argc < 3) {
  
      fprintf(stderr, 
          "Usage: %s in.fits box\n", 
           argv[0]);
        exit(1);
  
  }

  sscanf(argv[2],"%i",&box);
 
  /* Allocate memory for ouput data arrays */
  if ( (sqsum=(float *)malloc(box*box*sizeof(float))) == NULL ||
       (rms=(float *)malloc(box*box*sizeof(float))) == NULL ){

    printf("readnoise: Memory allocation failed!\n");
    exit(1);
  
  }
  
  /* Read in the science extensions */
  data=read_ME_FITS(argv[1], "SCI", axes, (axes+1), &nextend);

  nsci=nextend / NIMSET;
  axes[2]=(long)nsci;

  /* Reorder the data to have 1st read at the bottom */
  nread=*(axes) * *(axes+1);
  nbytes=nread*nsci*sizeof(float);

  /* Put the data into subarrays */
  /* ( fit expects arrays which start at 1 not 0 ) */

  if ( nsci>199 ){
    printf("Too many extensions, increase x and y arrays in readnoise.c\n");
    exit(1);
  }

  for(k=0; k<box; k++){ /* This represents y */

    for(j=0; j<box; j++){ /* This represents x */
      
      for(i=1; i<=nsci; i++){
	x[i]=(float)i;
	y[i]=*(data + (nsci-i)*nread + k**(axes) + j );
	
      }
      
      /* Fit them to a straight line and return the intercept and gradient */
      fit(x, y, nsci, sig, mwt, &a, &b, &siga, &sigb, &chi2, &q);

      /* Subtract actual value from fit and accumulate variance */
      sqsum[j+box*k]=0;

      for(i=1; i<nsci; i++){

	sqsum[j+box*k] += ( y[i] - b*i - a ) * ( y[i] - b*i - a )  ;

      }

      rms[j+box*k]=sqrt( ( 1/((float)nsci-1) ) * sqsum[j+box*k] );  

    }
    
  }

  /* Find out the gain */  
  if ( fits_open_file(&fptr, argv[1], READONLY, &status) )  
    printerror ( status ) ;

  /* Get info from header */
  if ( fits_read_key(fptr, TFLOAT, "GAIN", &gain, NULL, &status) )
    printerror ( status ) ;
 
  /* Close the file freeing memory allocated for fitsfile fptr */
  if ( fits_close_file(fptr, &status) )
    printerror ( status );

  average=0;
  
  for(k=0; k<box; k++){
    
    for(j=0; j<box; j++){
      
      /*   printf("readnoise: rms noise in pixel %d,%d = %fDN = %fe-\n",
	     j+1,k+1,*(rms+k*box+j),*(rms+k*box+j)*gain);
      */
      average+=*(rms+k*box+j);
      
    }
    
  }
  
  average/=(box*box);

  printf("readnoise: average rms noise in %d by %d box = %fDN = %fe-\n",
	 box,box,average,average*gain);
  

  free(sqsum);
  free(rms);
  free(data);

  return 0;

}



