/* C program to take all the science extensions for a Cirpass
** MEF file and convert it into a 3d data cube - makes the output
** look like that from the old pipeline and makes it easier to 
** run some of the iraf tasks
**
** AJ Dean, 22nd Nov, 2000.
**
*/

#include <stdlib.h>
#include "fitswrap.h"

int main(int argc, char* argv[])
{

  float* data;
  float* tempdata;
  int nextend=0;
  long axes[3]={0};
  int nsci=0;
  int nread=0;
  int nbytes=0;
  int i=0;
  int j=0;

  /* Check for appropriate input */
  if (argc < 3) {
  
      fprintf(stderr, 
          "Usage: %s in.fits out.fits  \n", 
           argv[0]);
        exit(1);
  
  }

  /* Read in the science extensions */
  data=read_ME_FITS(argv[1], "SCI", axes, (axes+1), &nextend);

  nsci=nextend / NIMSET;
  axes[2]=(long)nsci;
  
  /* Reorder the data to have 1st read at the bottom */
  nread=*(axes) * *(axes+1);
  nbytes=nread*nsci*sizeof(float);

  /* Allocate memory */
  if ( (tempdata=(float *)malloc(nbytes)) == NULL ){
    printf("makecube: Memory allocation failed!");
    exit(1);
  }

  for(i=0; i<nsci; i++){
    
    for(j=0; j<nread; j++){

      *(tempdata + i*nread + j) = *(data + (nsci-i-1)*nread + j);

    }

  }


  /* Write out the data cube */
  if( write_3d_cube(argv[2], tempdata, axes, 3) ){
    printf("makecube: write_3d_cube failed\n");
    exit(1);
  }

  free(data);
  free(tempdata);

  return 0;

}



