###############################################################################
# Data reduction pipeline for Cirpass using win98 PixCel.
# Works on raw data output by PixCel which is mosaiced and contains
# all the correct keywords.
#
# Created by RAJ 18 Oct 2000
##############################################################################

procedure docirpass(name,run_no,dateobs,stackno,boxsize,firstread,lastread,xpix,ypix)

string name {prompt="Root name"}
string run_no {prompt="Run no."}
string dateobs {prompt="Date of observations"}
string stackno {prompt="Stack the n'th read of every loop, or all"}
int    boxsize {prompt="box size to average"}
string createdir {prompt="Should I create it (y/n)?"}
int    firstread {prompt="first read to average over"}
int    lastread {prompt="last read to average over"}
int    xpix     {prompt="x pixel to look at"}
int    ypix     {prompt="y pixel to look at"}


struct *in {mode="h"}

begin


string fname,frunno,fdateobs,fstackno
string rawdir,reddir,file1,rawfile,stackout,readno,tempfile,outfile
string tempfile1,stackph

string dbfile, imaout,imaoutroot,imaph,ans, cfgfile
string sciname,tempstr

real gain,readnoise
int nexn,len,beg,nloops,nreads,ifstackno,totnum,inc,junk
int box

int first,last,x,y

bool rawexist,redexist,stackexist,rawdatexist
bool zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc
bool extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc,datred

#########################query parameters#####################################
#except stack no
fname=name
frunno=run_no
fdateobs=dateobs
box=boxsize
first=firstread
last=lastread
x=xpix
y=ypix


########################constant variables####################################
#set in cirpasspars.par
nexn=cirpasspars.nexn
sciname=cirpasspars.sciname

##########################set up procedures####################################
##load required packages
utils
fitsutil

##find names of raw and pipeline reduced data directory
##these env variables are currently set in cirpass.cl
transenv("cirpraw") | scan(rawdir)
transenv("cirpred") | scan(reddir)
##if these don't end in / then add one
len=strlen(rawdir)
if(substr(rawdir,len,len)!="/")
  rawdir=rawdir//"/"
len=strlen(reddir)
if(substr(reddir,len,len)!="/")
  reddir=reddir//"/"

rawdir=rawdir//fdateobs
reddir=reddir//fdateobs

##check these directories exist
rawexist=yes
if(!access(rawdir))
  rawexist=no

redexist=yes
if(!access(reddir))
  redexist=no

##if pipeline reduced directory doesn't exist then offer
##to create it. If not created then stop
if(!redexist){
  print("Pipeline reduction directory ",reddir," doesn't exist")
  ans=createdir
  if(ans=="y"){
    mkdir(reddir)
  }
  else{
    error(11,"Pipeline reduction directory "//reddir//" not found")
  }
}

##add / to raw and reduced
##do this after checking it exists otherwise check doesnt work
rawdir=rawdir//"/"
reddir=reddir//"/"
print("Raw data directory ",rawdir)
print("Reduced data directory ",reddir)

## Sort out the PixCel run numbering scheme
## eg run 1 is numbered run 0001
## run nos should be 1-9999
    frunno="000"//frunno
    len=strlen(frunno)
    beg=len-3
    frunno=substr(frunno,beg,len)

########printing no of loops and reads in this data#######################
##have to get this info from a raw file as don't know what other files exist 
##yet. nloops and nreads found here to remind user before they
##decide which to stack (used later also). 
##they may not do any stacking anyway if stacked
##file exists already, so don't stop if the raw data file doesn't exist
file1=rawdir//fname//"_"//frunno//"_c1_000.fits"
print("file1 ",file1)
if(access(file1)){
  hselect(file1,"nloops",yes) | scan(nloops)
  hselect(file1,"nreads",yes) | scan(nreads)
  print("Loops ",nloops," Reads ",nreads)
}

##query parameter stackno
fstackno=stackno
if(fstackno!="all"){
  ifstackno=int(fstackno)

##check that the number asked for makes sense
  while(ifstackno>nreads){
    print("Only "//nreads//" reads per loop and you asked me to stack read number "//fstackno)
  fstackno=stackno
  ifstackno=int(fstackno)
  }

}
else{
  ifstackno=1
}

########check if stacked files already exist######################
rawexist=yes
stackexist=yes
##stacked files

stackout=reddir//fname//"_"//frunno//"_raw.fits"

if(!access(stackout))
  stackexist=no

##if stacked file doesn't exist then worry about whether the raw data exists
if(!stackexist){
  print("Stack file ",stackout," doesn't exist")
##if raw data directory doesn't exist then stop
  if(!rawexist)
    error(10,"Stacked file doesn't exist and raw data directory doesn't exist so can't create _raw file")

##check that all raw data exists
##set rawdatexist=no if not all of them exist
##can't do anything unless they all exist
##raw files have the form name_runno_c1_00#.fits
##file1 is the name of the raw first read (defined it already above)
##if this doesn't exist then not all raw files exist so rawdatexist is no
  rawdatexist=yes
  if(!access(file1)){
    rawdatexist=no
  }
##if this does exist, then already know nloops and nreads from above
##check that all the required raw files exist
  else{
##work out total number of reads (= total number of raw files) from
##nloops and nreads
    totnum=(nloops+1)*nreads;
    print("Total number of reads ",totnum)
    for(i=0;i<totnum;i+=1){
      print("i ",i)
      readno="00"//i
      len=strlen(readno)
      beg=len-2
      readno=substr(readno,beg,len)
      rawfile=rawdir//fname//"_"//frunno//"_c1_"//readno//".fits"
      print("rawfile ",rawfile)
      if(!access(rawfile))
        rawdatexist=no
    }
  }
##if raw files don't exist and stack file
##doesn't exist then stop as can't read raw data to make stacked file
  if(!rawdatexist)
    error(10,"Raw data and stacked _raw file don't exist so can't do anything")

#########################stacking##############################################
##still in if(!stackexist)
##if there is no stack file then make one
##run stack_read
##create output file

##create temp file containing list of files to be stacked
  tempfile=mktemp("temp")
  print("tempfile ",tempfile)
##do this with a loop to get the correct order
  print("Stacking files")
  if(fstackno=="all"){
    inc=1;
  }
  else{
    inc=nreads;
  }
  for(i=ifstackno-1;i<totnum;i+=inc){     
      readno="00"//i
      len=strlen(readno)
      beg=len-2
      readno=substr(readno,beg,len)
      outfile=rawdir//fname//"_"//frunno//"_c1_"//readno//".fits"
      print(outfile)
      print(outfile,>>tempfile)
  }
##stackout is output stacked file

  stackout=reddir//fname//"_"//frunno//"_cube.fits"
  print("Running cube_data. Output file is ",stackout)

##do stacking
  tempfile1="@"//tempfile
  cube_data(tempfile1,stackout)

##delete tempfile
  delete(tempfile)

}
##end of if(!stackexist)
else{
  print("Stack file ",stackout," exists")
}

#call the readnoise script

print("doread: running rdncube")
rdncube(stackout,box,first,last,x,y)

#########################tidy up###############################################
##increment the run no at the end so it's set for the next run
run_no=frunno+1
###############################################################################

end

