/* C program providing the user interface to the fitswrap library
 * function overwrite_ext, which will overwrite an extension in a
 * fits file
 *
 * A. J. Dean 27th May, 2003
 *
 */

#include <stdlib.h>
#include "fitswrap.h"

int main(int argc, char* argv[])
{

  long axes[2]; /* fitswrap routines used expect 2D data */
  float* data=NULL;
  int extver=0;

  /* Check for appropriate input */
  if (argc < 5) {
    fprintf(stderr,
            "Usage: %s file_to_overwrite file_containing_new_data extension_name extension_version\n",
            argv[0]);
    exit(1);
  }

  sscanf(argv[4],"%i",&extver);

  data=readfits_float_clever(argv[2], axes);
  
  overwrite_ext(argv[1], data, axes, argv[3], &extver);

  free(data);

  return 0;

}
