/* mosaic. c
 *
 * C program to mosaic the images output from pixcel as it can't
 * do that for the 2k detector
 *
 * AJ Dean. 10th September, 2001
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fitswrap.h"

static int rotate90(float* data, float* rotated, int nx, int ny);
static int rotate180(float* data, float* rotated, int nx, int ny);
static int rotate270(float* data, float* rotated, int nx, int ny);

int main(int argc, char* argv[])
{
 
  char* keynames[]={"NAXIS1","NAXIS2","NLOOPS","NREADS"};
  float data[4]={0};        /* Above keyword data */
  int nloops=0;
  int nreads=0;
  int nx=0;                 /* Image dimensions */
  int ny=0;
  int i=0;                  /* Loops variables */
  int j=0;
  int x=0;                 
  int y=0;
  int filenum=0;
  char* filenames[5];       /* For the different quadrants and output name */
  float* imagedata[4];      
  float* rotateddata[4];
  float* outimage=NULL;
  char endstring[11];
  int stringlength=0;
  long naxes[2];

  /* Check for appropriate input */
  if (argc < 2) {
    fprintf(stderr, 
            "Usage: %s first_file.fits\n", 
            argv[0]);
    exit(1);
  }
  
  /* Find out how many loops and reads */
  read_float_keys(argv[1], keynames, data, 4);
  nx    =*(data);
  ny    =*(data+1);
  nloops=*(data+2);
  nreads=*(data+3);
  naxes[0]=nx*2;
  naxes[1]=ny*2;
  stringlength=strlen(argv[1]);
  stringlength++; /* Add in for the trailing zero */

  filenum=0;
 
   /* Allocate memory */
  for(i=0; i<5; i++){
    
    if ( (filenames[i]=(char *)malloc(stringlength*sizeof(char))) == NULL ){
      printf("mosaic: Memory allocation failed!");
      exit(1);
    }
    
  }
  
  for(i=0; i<4; i++){
    
    if ( (rotateddata[i]=(float *)malloc(nx*ny*sizeof(float))) == NULL ){
      printf("mosaic: Memory allocation failed!");
      exit(1);
    }
    
  }
  
  if ( (outimage=(float *)malloc(2*nx*2*ny*sizeof(float))) == NULL ){
    printf("mosaic: Memory allocation failed!");
    exit(1);
  }
  
  /* Sort out the quadrant names */
  filenum=0;
  
  /* Loop over loops */
  for(j=0; j<(nloops+1)*nreads; j++){

	for(i=0; i<4; i++){ /* Loop over quadrants */
    
	  sprintf(endstring,"%i_%.3d.fits",i+1,filenum+i);
	  strcpy(*(filenames+i),argv[1]);
	  strcpy((*(filenames+i)+stringlength-11),endstring);
	  /*printf("reading data %s\n",*(filenames+i)); */
	  imagedata[i]=readfits_float(filenames[i],0);
		  
	}

	rotate90(imagedata[0],rotateddata[0],nx,ny);
	rotate270(imagedata[2],rotateddata[2],nx,ny);
	rotate180(imagedata[3],rotateddata[3],nx,ny);

	/* Reassemble data into new image */
	for(y=0; y<ny; y++){
	  
	  for(x=0; x<nx; x++){

	  *(outimage+x+y*2*nx)=*(rotateddata[0]+x+y*nx);	    
	  *(outimage+x+y*2*nx+2*nx*ny)=*(rotateddata[3]+x+y*nx);
	  *(outimage+x+y*2*nx+2*nx*ny+nx)=*(rotateddata[2]+x+y*nx);
	  *(outimage+x+y*2*nx+nx)=*(imagedata[1]+x+y*nx);
	
	  }

	}
	
	/* Write out image */
	sprintf(endstring,"c1_%.3d.fits",j);
	strcpy(*(filenames+4),*(filenames));
	strcpy((*(filenames+4)+stringlength-14),endstring);
	/*printf("Writing %s\n",*(filenames+1));*/
	writefits_float_header(*(filenames+4), *(filenames), naxes, 2, 
			       outimage);

	/* Delete the original data */	
	/*for(i=0; i<4; i++){
	  remove(*(filenames+i));
	  }*/

	filenum+=4;
	if(filenum>996){
	  printf("More data than was expected when writing this code!\n");
	  printf("Filename array can not accomodate > 999 at end of name\n");
	  printf("Edit mosaic.c to fix this\n");
	  exit(1);
	}

  }
  
  for(i=0; i<4; i++){
    free(*(imagedata+i));
    free(*(rotateddata+i));
  }
  for(i=0; i<5; i++){
    free(*(filenames+i));
  }
  free(outimage);
  
  return 0;

}

static int rotate90(float* data, float* rotated, int nx, int ny)
{

  int i=0;
  int j=0;

  for(j=0; j<ny; j++){

    for(i=0; i<nx; i++){

      *(rotated + i + nx*j)=*(data + (ny-j-1) + i*ny);


    }

  }

  return 0;

}

static int rotate180(float* data, float* rotated, int nx, int ny)
{

  int i=0;
  int j=0;

  for(j=0; j<ny; j++){

    for(i=0; i<nx; i++){

      *(rotated + i + nx*j)=*(data + (nx-i-1) + (ny-j-1)*nx);


    }

  }

  return 0;

}

static int rotate270(float* data, float* rotated, int nx, int ny)
{

  int i=0;
  int j=0;

  for(j=0; j<ny; j++){

    for(i=0; i<nx; i++){

      *(rotated + i + nx*j)=*(data + j + (nx-i-1)*ny);


    }

  }

  return 0;

}
