/* lenssort.c
** 
** Uses the fibre configuration info to return the lens positions.
**
** A J Dean. 18th June, 2001.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "lenssort.h"
#include "cirpass.h"
/* #define DEBUG */

extern float** lenssort(float** configdata, int numconfig, int* numlenses)
{


  int i=0;
  int lenscount=0;
  float** lensdata=NULL;
  int count=0;          /* Index for lens number */

  /* Find out how many lenses altogether */

  for(i=0; i<numconfig; i++){

    if( *( *(configdata+1) + i) != CALFIBRE){

      lenscount+=1;

    }

  }
  
  *numlenses=lenscount;
  
  /* Allocate memory for output array */
  
  if ( ( lensdata=(float**)malloc(2*sizeof(float*)) ) == NULL ){
    printf("specsort: Memory allocation failed!");
    exit(1);
  }
  
  for(i=0; i<2; i++){

    if ( ( *(lensdata+i)=(float*)malloc(lenscount*sizeof(float)) ) == NULL ){
      printf("specsort: Memory allocation failed!");
      exit(1);
    }
    
  }

  /* Fill lensdata performing appropriate shifts */
  
  count=0; /* Follows lenses in the IFU */
 
  for(i=0; i<numconfig; i++){

    if( ( *(*(configdata+1)+i) != CALFIBRE ) ){  /* We have a lens */

	*( *(lensdata)+count ) = *( *(configdata+1)+i ); 
	*( *(lensdata+1)+count ) = *( *(configdata+2)+i );
	
	count++;
      
    }
    
  }
  
  return lensdata;
  
}

