/* insert_table.c
 *
 * c program to insert a table into a MEF file!
 *
 * A. J. Dean 10th Aug, 2002
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "fitswrap.h"

int main(int argc, char* argv[])
{

  float fibreid[20000]={0};
  float x[20000]={0};
  float y[20000]={0};
  float ap[20000]={0};

  int i=0;
  int num=0;
 
  char* keywords[]={"YOVERX","MAXDIST"};
  char* colnames[]={"FibreID", "xcord", "ycord","apnum"};
  float* data[4];
  float* keydata[2];

  float yoverx=1.7320508;
  float maxdist=1.1547005;
 
  FILE* table_data;


  /* Check for appropriate input */
  if (argc < 3) {
    
    fprintf(stderr, 
	    "Usage: %s mef_file.fits position_file\n", 
	    argv[0]);
    exit(1);
    
  }
  
  
  /* Read in the data for the table */
  if ( !(table_data = fopen(argv[2],"r")) ){
    
    printf("Failed to open the table data ascii file\n");
    exit(1);
  
  }
          
  i=0;
  while ( fscanf(table_data,"%f %f %f %f",(fibreid+i),(x+i),
		 (y+i),(ap+i)) !=EOF ){
    
    /*printf("%f %f %f %f\n",fibreid[i],x[i],y[i],ap[i]);*/
    i+=1;
    if( i>=20000 ){
      printf("Too many data points in file.\n Limit is currently 20000.\n") ;
      exit (1);
    }
    
  }

  num=i;

  data[0]=fibreid;
  data[1]=x;
  data[2]=y;
  data[3]=ap;

  keydata[0]=&yoverx;
  keydata[1]=&maxdist;

  insert_table(argv[1], 1, 2, keywords, keydata, 4, colnames, 
	       num, data);
  
  /* Close the table data file */
  fclose(table_data);

  return 0;

}











