/* hotpix.c -- Produces a list of the hotpixels in an image
**
** Andrew J. Dean. 11th July, 2001.   
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fitswrap.h"     /* for printerror and cfitsio */

/* Start of main code */

int main(int argc, char* argv[])
{

  /* Local variables */
  
  FILE* outfile;

  float* data;                   /* Array for whole image data */
  long axes[2];                  /* Image dimensions */
  float hotpix_val;              /* Pixel values above this are hot pixels */
  int count=0;                   /* Count of number of hot pixels */

  int i=0;                       /* Loop variables */
  int j=0;

  /* Check for appropriate input */
  if (argc < 4) {
    fprintf(stderr, 
            "Usage: %s scidata.fits output_file hotpix_val\n", 
            argv[0]);
    exit(1);
  }
 
  sscanf(argv[3],"%f",&hotpix_val);

  /* read in the input data */
  data=readfits_float_clever(argv[1], axes);

  /* Open the output file */
  if ( !(outfile = fopen(argv[2],"w")) ){
    
    printf("Failed to open the output file\n");
    exit(1);
  }

  /* Loop over and flag hot pixels */
  count=0;

  for(j=0; j<axes[1]; j++){

    for(i=0; i<axes[0]; i++){

      if( *(data + j*axes[0] + i) > hotpix_val ){

	fprintf(outfile,"%i %i\n",i+1,j+1);
	count++;

      }

    }

  }

  fclose(outfile); 

  printf("hotpix: Found %d hotpixels\n", count);
  
  /* Free memory allocated locally */
  free (data);
    
  /* successful return */
  return 0;

}






