/* C Program findap
**
** Determines which aperture corresponds to a pixel in the output
** image from ifudisplay
**
** AJ Dean. 15th June, 2001
*/

#include <stdlib.h>
#include <math.h>
#include "fitswrap.h"
#include "sumspec.h"
#include "specsort.h"
#include "cirpass.h"
#include "lenssort.h"

#define ERROR -1

static int minmax(float* values, int nvals, float* min, float* max);
static int round(float val);
static float distsq(int x1, int y1, float x2, float y2, float ratio);

int main(int argc, char* argv[])
{

  float xpix=0;           /* x values in pixel units */
  float ypix=0;           /* y values in pixel units */
  float xspace=0;         /* x pixel spacing of points on grid */
  float yspace=0;         /* y pixel spacing of points on grid */  
  float* xgrid=0;         /* x values on arbitary ifu grid */
  float* ygrid=0;         /* y values on arbitary ifu grid */
  float yoverx=0;         /* Ratio of the grid axes */
  float mingridx=0;       /* Size of the grid */ 
  float maxgridx=0;
  float mingridy=0;
  float maxgridy=0;
  float xgridsize=0;
  float ygridsize=0;
  float xgridmid=0;
  float ygridmid=0;

  double root3;         /* Root 3 */
  int numlenses=0;      /* Number of lenses to be displayed */
  float offsetx=0;      /* Pixel values for middle of display */
  float offsety=0;        
  int middle=0;         
  float maxdist=0;      /* max dist object can be from centre in terms of x */

  int i=0;              /* Loop variables */
  int j=0;
  int k=0;

  float** configdata=NULL;
  char* keywords[]={"YOVERX","MAXDIST"};
  float* keydata[2]; 
  int numhead=2;
  int numcols;          /* Number of cols + rows in table extension */
  int numrows;

  float apxgrid=0;
  float apygrid=0;
  int iapxgrid=0;
  int iapygrid=0;
  int closegrid[2][9];
  int outapar[9];
  int outap=0;
  int outputgrid[2]={0};
  float tempdist=0;
  float currclosest=0;
  int count=0;
 
  float*  specdata=NULL;
  float** lensdata=NULL;

  keydata[0]=&yoverx;
  keydata[1]=&maxdist;

 
  /* check for appropriate input */
  if ( argc < 4 ) {
    fprintf(stderr, 
	    "Usage: %s MEF-file xpix ypix\n", 
	    argv[0]);
    exit(1);
  }

  sscanf(argv[2],"%f",&xpix);
  sscanf(argv[3],"%f",&ypix);

  /* Read in the binary table data from the MEF file */
  configdata=read_table(argv[1], 2, numhead, keywords, keydata, &numcols, 
       &numrows);

  /* Find out the lens positions */
  lensdata=lenssort(configdata, numrows, &numlenses);

  xgrid=*(lensdata+0);
  ygrid=*(lensdata+1);

  root3=sqrt(3);

  /* Find out the size of the grid */

  if ( minmax(xgrid,numlenses,&mingridx,&maxgridx) ){
    printf("minmax routine failed!\n");
    exit(1);
  }

  if ( minmax(ygrid,numlenses,&mingridy,&maxgridy) ){
    printf("minmax routine failed!\n");
    exit(1);
  }
  
  /* Find out which axis is longest and set spacing accordingly */

  xgridsize=maxgridx-mingridx;
  ygridsize=maxgridy-mingridy;
  xgridmid=(maxgridx+mingridx)/2.0;
  ygridmid=(maxgridy+mingridy)/2.0;

  /* The .1 is a bit of extra space to account for the cases where the middle
   * of the grid falls exactly on a pixel, whereby one end will rap around 1 
   * pixel to the other side if the grid fits exactly into the full width.
   */
  if ( xgridsize*yoverx > ygridsize ){
   
    xspace=(DISPSIZE)/(xgridsize+2.1);
    yspace=xspace*yoverx;

  } else {
    
    yspace=(DISPSIZE)/(ygridsize+2.1);
    xspace=yspace/yoverx;

  }
    
  middle=((int)(DISPSIZE/2.0))*DISPSIZE + round((DISPSIZE+1)/2.0) - 1;
  offsetx=xgridmid*xspace;
  offsety=ygridmid*yspace;
  
  apxgrid=  ( xpix + offsetx - ((DISPSIZE+1)/2.0) ) /xspace ;
  apygrid=  ( ypix + offsety - ((DISPSIZE+1)/2.0) ) /yspace ;

  /* Find out which grid positions are allowed close to the chosen point
   */
  
  iapxgrid=round(apxgrid);
  iapygrid=round(apygrid);
  
  /*
  printf("float grid is %f %f\n", apxgrid, apygrid);
  printf("integer grid is %d %d\n", iapxgrid, iapygrid);
  */

  count=0;
  
  for(k=0; k<numrows; k++){

    for(j=iapygrid-1; j<=apygrid+1; j++){
      
      for(i=iapxgrid-1; i<=apxgrid+1; i++){

	if( ( ((int)*( *(configdata+1)+k )) == i ) &&
	    ( ((int)*( *(configdata+2)+k )) == j ) ){
	  
	  closegrid[0][count]=i;
	  closegrid[1][count]=j;
	  outapar[count]=(int)*( *(configdata+3)+k);
	  count++;
	  /* printf("grid %d %d  allowed\n",i,j); */

	} 
      
      }

    }

  }

  /* check we got a grid position otherwise return error code */
  if( count==0 ){
    printf("%d\n",ERROR);
    return 0;

  }

  /* Of the grid positions find out which is closest */
  currclosest=distsq(iapxgrid,iapygrid,closegrid[0][0],closegrid[1][0],
		       yoverx);
  outputgrid[0]=closegrid[0][0];
  outputgrid[1]=closegrid[1][0];
  outap=outapar[0];


  for(i=0; i<count; i++){

    tempdist=distsq(closegrid[0][i],closegrid[1][i],apxgrid,apygrid,
		    yoverx);
    
    if( tempdist < currclosest ){
      
      currclosest=tempdist;
      outputgrid[0]=closegrid[0][i];
      outputgrid[1]=closegrid[1][i];
      outap=outapar[i];
      
    }
    
  }
    
  /* printf("output grid is %d %d\n",outputgrid[0],outputgrid[1]); */
      
  printf("%d\n",outap);

  /* Clean up */
  for(i=0; i<2; i++){
    free( *(configdata+i) );
  }
  free(configdata); 
  
  free(specdata);
    
  for(i=0;i<1; i++){
    free( *(lensdata+i) );
  }
  free(lensdata);
  
  return 0;

}
      
static int minmax(float* values, int nvals, float* min, float* max)
{

  int i=0;
  float mintemp=0;
  float maxtemp=0;

  mintemp=*(values);
  maxtemp=*(values);

  for(i=0; i<nvals; i++){
    
    if ( *(values+i) < mintemp ){
      mintemp=*(values+i);
    }
    
    if ( *(values+i) > maxtemp){
      maxtemp=*(values+i);
    }

  }

  *(min)=mintemp;
  *(max)=maxtemp;

  return 0;

}

static int round(float val)
{

  return ( val < 0.0 ? (int)(val-0.5) : (int)(val+0.5) );

}

static float distsq(int x1, int y1, float x2, float y2, float ratio)
{
  
  return ( ((float)(x1)-x2)*((float)(x1)-x2) + 
	   ((float)(y1)-y2)*((float)(y1)-y2)*ratio*ratio );

}






