#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fitsio.h"


void printerror(int status);

int main(int argc, char *argv[])
{
    

  fitsfile *fptr;
  int status=0;
  char* p_infile;

  char infile[80];
  int fpixel=1;
  int nread=100;
  int nullvall=0;

  float data[100];
  int anynull;
  int i;

  p_infile=&infile[0];

  if (argc < 2) {
        fprintf(stderr, 
          "Usage: %s infile.fits\n", 
           argv[0]);
        exit(1);
  }

  p_infile=strcpy(p_infile,argv[1]);

  if ( fits_open_file(&fptr, p_infile, READONLY, &status) )
    
    printerror ( status ) ;


 
  if ( fits_read_img(fptr, TFLOAT, fpixel,nread,&nullvall,data, &anynull, &status) )
    printerror( status );
     
    for(i=0;i<100;i++){

      printf("%f \n",data[i]);
    }
    
    if ( fits_close_file(fptr, &status) )
      printerror ( status );



    return 0;
}


void printerror(int status)
{
  if (status)
    { 
      fits_report_error(stderr, status);
      exit( status );
    }
  return;
}

