# mossort.cl
#
# Runs on an optextracted MOS image, and reorders it
# combining the A and B beam-switched pairs
#
# A. J. Dean 5th Dec, 2002

procedure mossort(filename, output_root, config_file, mosmap)

string filename {prompt="Input optextracted image"}
#string beam_position {prompt="Is this an A or a B target position?",enum="A|B"}
string output_root {prompt="Name for the sorted output files"}
string config_file {prompt="File containing the MOS configuration for the observation"}
string mosmap {"CIRPBIN$../MOSdat/cirpass-mos.cfg", prompt="File containing slit position -> fibre label map"}
string logfile {prompt="Log file"}

struct *in {mode="h"}

begin

string name, position, outfile, config, p_mosmap, log_file
#string out1, out2
string tempfile, tempfile2, tempfile3, junk
string tempfile4, tempfile5, tempfile6, tempfile7
int slit_pos[1000] # Position of labelled fibre in slit
int fibre_label[1000] # Label of fibre in slit, at position slit_pos
int mappinga[1000,3] # object_id slit_pos object_hole a array
int mappingb[1000,3] # object_id slit_pos object_hole b array
real posmapa[1000,2] # RA DEC a array
real posmapb[1000,2] # RA DEC b array
int numtotal, numexpected
int i,j, count, len
int a, b, c, d, unwanted
real e, f
int answer
int fibres_used[1000] # Fibre label in current observation	
int object_hole[1000] # Hole in fibre plate object plugged into
int object_id[1000] # object counter
int beam_pos[1000] # Is this an A or B beam-switch position
real RA[1000] # RA of object viewed by fibre
real DEC[1000] # DEC of object viewed by fibre
bool exist

name=filename
#position=beam_position
outfile=output_root
config=config_file
p_mosmap=mosmap
log_file=logfile

# check if config_file file exists
exist=access(config)
if(!exist){
		print("MOS config file does not exist!")
		bye		
		
}

# check if mosmap file exists
exist=access(p_mosmap)
if(!exist){
		print("MOS map file does not exist!")
		bye		
		
}

# Load required packages
tables
fitsutil
utils

# check for .fits on the end of input image file

        len=strlen(name)
        if(substr(name,len-4,len)!=".fits") {
                name=name//".fits"
        }


# Read in info from table header

# Do this from the config file now, to ensure it will
# always work, regardless of whether the table is correct

#tempfile=mktemp("_temp_")
#tprint(name,>tempfile)

#in=tempfile
in=p_mosmap
i=1
# skip the 5 lines of text at the top of the file
#for(j=1; j<=5; j+=1){
#	answer=fscanf(in,"%s",junk)
#}

# skip the 1 line of text at the top of the file
for(j=1; j<=1; j+=1){
	answer=fscanf(in,"%s",junk)
}


#while(fscan(in,unwanted,a,b)!=EOF){
while(fscan(in,a,b,unwanted)!=EOF){
	slit_pos[i]=a
	fibre_label[i]=b
	#print("i ",i,"found at position ",slit_pos[i],fibre_label[i])
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

numtotal=i-1
print(numtotal, "fibres in slit according to image header")

in=config
i=1
while(fscan(in,a,b,c,d,e,f)!=EOF){
	fibres_used[i]=a
	object_hole[i]=b
	object_id[i]=c
	beam_pos[i]=d
	RA[i]=e
	DEC[i]=f
	#print("i ",i,"data is ",a,b,c,d,e,f)
  i+=1
  if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  }

}

numexpected=i-1
print(numexpected, "object fibres expected in the data set")

# Figure out the expected positions of the fibres on the detector
# now that know the labelling scheme and the fibres that
# where used in the observation.

tempfile2=mktemp("_temp2_")
tempfile3=mktemp("_temp3_")
count=1
for(i=1; i<=numexpected; i+=1){

	for(j=1; j<=numtotal; j+=1){

		if( fibres_used[i]==fibre_label[j] ){
			
			if(beam_pos[i]==1){
				print(object_id[i], slit_pos[j], 
				      object_hole[i], beam_pos[i],
				      RA[i], DEC[i], >>tempfile2)
			}
			if(beam_pos[i]==2){
				print(object_id[i], slit_pos[j], 
				      object_hole[i], beam_pos[i],
				      RA[i], DEC[i], >>tempfile3)
			}
			count+=1
			next
		
		}

	}

}

if ( (count-1) != numexpected ){
	print("moscal: ERROR! Could not match up fibre labels")
	print("moscal: to a position in the slit!")
	bye
}

print((count-1),"fibre positions matched with labels")

tempfile4=mktemp("A_positions")
tempfile5=mktemp("B_positions")

sort("-n", tempfile2, >tempfile4)
sort("-n", tempfile3, >tempfile5)

# Read the data back into memory now it's sorted

in=tempfile4
i=1
while(fscan(in,a,b,c,d,e,f)!=EOF){
	
	mappinga[i,1]=a
	mappinga[i,2]=b
	mappinga[i,3]=c
	posmapa[i,1]=e
	posmapa[i,2]=f

	i+=1
  	if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  	}	

}	

if( (i-1)!=(numexpected/2) ){
	print("Oops, something's gone a bit wrong!")
	bye
}

in=tempfile5
i=1
while(fscan(in,a,b,c,d,e,f)!=EOF){
	
	mappingb[i,1]=a
	mappingb[i,2]=b
	mappingb[i,3]=c
	posmapb[i,1]=e
	posmapb[i,2]=f

	i+=1
  	if(i>=1000){
	     error(11,"Array for positions found run out of room!")
  	}	

}	

if( (i-1)!=(numexpected/2) ){
	print("Oops, something's gone a bit wrong!")
	bye
}

# Copy over and reorder the data

#if(position=="A"){

#	out1=outfile//"_objects.ms"
#	out2=outfile//"_sky.ms"

#} else {

#	out1=outfile//"_sky.ms"
#	out2=outfile//"_objects.ms"
#
#}

# check for .fits on the end of output file

#        len=strlen(outfile)
#        if(substr(outfile,len-4,len)==".fits") {
#                outfile=substr(outfile,1,len-5)
#        }

	len=strlen(outfile)
       	if(substr(outfile,len-4,len)!=".fits") {
                outfile=outfile//".fits"
        }


#outfile=outfile//".ms"

tempfile6=mktemp("_temp_ms_output_")
tempfile6=tempfile6//".fits"
tempfile7=mktemp("_table_file_")

print("FibreID xcord ycord apnum Pos RA DEC",>> tempfile7)

for(i=1; i<=(numexpected/2); i+=1){

	print("Object position in .ms file is ", mappinga[i,1], 
      	      "and its plate hole was ", mappinga[i,3], 
              "\nthe fibre positions (not labels!) were:", >> logfile)
	sarith(name//"[sci,1][*,"//mappinga[i,2]//"]", "-",
       	       name//"[sci,1][*,"//mappingb[i,2]//"]", 
       	       tempfile6, format="multispec", renumber+, offset=0, clobber+, 
       	       merge+, verb+, >> log_file)
	print("-999 ", "-999 ", "-999 ", "-999 ", i, posmapa[i,1],
	      posmapa[i,2],>>tempfile7)
	
#scopy(name//"[sci,1][*,"//mappinga[i,2]//"]", out1, format = "multispec",
#      renumber+, offset=0, clobber+, merge+, verb-)

#scopy(name//"[sci,1][*,"//mappingb[i,2]//"]", out2, format = "multispec",
#      renumber+, offset=0, clobber+, merge+, verb-)

}

makemef3(name,tempfile6,outfile)
#fxdelete(outfile,"1",verb-)
#addtable(outfile,tempfile7,numexpected/2)

overwrite_table(outfile,tempfile7,fix+)

#delete(tempfile)
delete(tempfile2)
delete(tempfile3)
delete(tempfile4)
delete(tempfile5)
delete(tempfile6)
delete(tempfile7)

end

