##############################################################################
# task get_gain                                                              #
#                                                                            #
# Takes an input list of ME-FITS files produced by the pipeline and          #
# determines the gain and readnoise at each pixel                            #
#                                                                            #
# A. J. Dean 11th Oct, 2000                                                  #
#                                                                            #
##############################################################################

procedure get_gain(filelist,flatfield,outfile,xcord,ycord,graph)

string filelist  {prompt="List of ME-FITS files of same exposure and reads (@file or template)"}
string flatfield {prompt="Flatfield file"}
string outfile   {prompt="Output gain and readnoise filename (something.fits)"}
int    xcord     {prompt="Top x pixel to look at"}
int    ycord     {prompt="Top y pixel to look at"}
bool   graph     {prompt="Graphical output? [yes/no] (.ps file otherwise)"}
string psfile    {mode="h", prompt="Output filename for the postscript file"}

struct *in

begin

	string ffilelist, fflatfield, foutfile, temp1, filename[500]
	string tempstr, tempflat, tempmean, tempsig, fpsfile
	int i, nexn, nextend, nsci, numfiles, x, y	
	bool dograph

# Number of extensions per imset, should really be a package paramater! 
	nexn=4

	ffilelist  = filelist
	fflatfield = flatfield
	foutfile   = outfile
	x 	   = xcord
	y 	   = ycord	
	dograph    = graph
	
	if (!dograph){
		fpsfile=psfile
	}

# Load required packages

	utils
	
# read input filelist into a temp file

	temp1=mktemp("temp")
	sections(ffilelist,option="fullname",>>temp1)
	in=temp1
	
	
# then read from tempfile into array
	i=1
	while(fscan(in,tempstr)!=EOF){
  	filename[i]=tempstr
	 print("i ",i," filename ",filename[i])
  	i+=1
	}
	
        numfiles=i-1
	delete(temp1)

# find out how many extensions in 1st file in list 
# assume they are all the same for now should really check this

	hselect(filename[1]//"[0]","NEXTEND","yes") | scan(nextend)
	nsci=nextend/nexn

# make up the flat fielded files (don't need var, dq and time so 
# just do it rather than using mefarith)
	
	tempflat=mktemp("temp_flat")
	print("Flatfielding the data")
	for(j=1; j<=numfiles; j+=1){

		for(i=1; i<=nsci; i+=1){ 

#			imarith(filename[j]//"[sci,"//i//"]","/",fflatfield,
#				tempflat//"_"//filename[j]//"_lev_"//i)

	imcopy(filename[j]//"[sci,"//i//"]",
		tempflat//"_"//filename[j]//"_lev_"//i)

	#	print("Wrote file  ",tempflat//"_"//filename[j]//"_lev_"//i)

		}
			
	}


# combine across the images at the same exposure level using imcombine
# to generate the mean and sigma images for each level

	tempmean=mktemp("temp_mean")
	tempsig=mktemp("temp_sig")

	print("Running imcombine")
	for(i=1; i<=nsci; i+=1){
	
		imcombine(tempflat//"_*_lev_"//i//".fits",tempmean//"_lev_"//i,
			  sigma=tempsig//"_lev_"//i,combine="average", proj-,
			 >& "dev$null")
	}

# Call the C program to fit a straight line to each pixel and thus determine
# the gain and readnoise per pixel

	if(dograph){
		
		c_get_gain(tempmean,tempsig,nsci,foutfile,x,y)

	} else {

		c_get_gain(tempmean,tempsig,nsci,foutfile,x,y,fpsfile)

	}

# Clean up

      delete(tempflat//"*")
#      delete(tempmean//"*")
#      delete(tempsig//"*")

end



