# badmask.cl
#
# iraf script to run on a flat field image to produce
# a bad pixel mask, and a cleaned flat field image
#
# The input flat field is smoothed in the x and y directions
# The original is then divided by the smoothed to highlight the bad pixels
# which can then be found by sigma clipping.

procedure badmask(flatfieldfile, badpixfile, cleanflatfile)

string flatfieldfile {prompt="Flat field file"}
string badpixfile {prompt="Output badpixel mask file"}
string cleanflatfile {prompt="Output fixpixed flat field file"}

begin

string flatfile, badfile, cleanfile 
string temp1, temp2, temp3, temp4, temp5, temp6
int sigma
real modevalue, stdev

flatfile=flatfieldfile
badfile=badpixfile
cleanfile=cleanflatfile

# maybe make this an input
sigma=1

# load in required packages
stsdas

temp1=mktemp("_temp1_")
temp2=mktemp("_temp2_")
temp3=mktemp("_temp3_")
temp4=mktemp("_temp4_")
temp5=mktemp("_temp5_")
temp6=mktemp("_temp6_")

blkavg(flatfile, temp1, option="average", b1=1, b2=1024)
blkrep(temp1, temp2, b1=1, b2=1024)
blkavg(flatfile, temp3, option="average", b1=1024, b2=1)
blkrep(temp3, temp4, b1=1024, b2=1)

imarith(temp2, "*", temp4, temp5)

imarith(flatfile, "/", temp5, temp6)

# Keep scan happy
modevalue=0
stdev=0

imstatistics(temp6, fields="mode", format-) | scan(modevalue)
imstatistics(temp6, fields="stddev", format-) | scan(stdev)

print("Mode of flat is ", modevalue, " standard deviation is ", stdev)

#print("if im1 .lt. "//modevalue//"+("//sigma//"*"//stdev//") .and. im1 .gt. "//modevalue//"-("//sigma//"*"//stdev//") then 0.0 else 1.0")

imcalc(temp6, badfile, "if im1 .lt. "//modevalue//"+("//sigma//"*"//stdev//") .and. im1 .gt. "//modevalue//"-("//sigma//"*"//stdev//") then 0.0 else 1.0")

imcopy(flatfile,cleanfile,ver-)
fixpix(cleanfile, badfile, linterp=1, cinterp=2)

imdel(temp1)
imdel(temp2)
imdel(temp3)
imdel(temp4)
imdel(temp5)
#imdel(temp6)

end

