# showtrace.cl
#
# Draws lines on the display window showing the trace identified
# by the fibtrace program
#
# A. J. Dean 05/11/01

procedure showtrace(lines_to_mark, fib_reference_file)

string lines_to_mark {prompt="File containing list of lines to mark"}
string fib_reference_file {prompt="Fibre position file"}
int frame {1,prompt="Display to which frame"}

struct *in {mode="h"}

begin

string lines
string reffile
string tempfile
int i, j, num, numlines, temp
real yref[508]
real fwhm[508]
real order[508]
real a1[508]
real a2[508]
real a3[508]
real tempreal1, tempreal2, tempreal3, tempreal4, tempreal5, tempreal6
int linearray[100]
int p_frame

lines=lines_to_mark
reffile=fib_reference_file
p_frame=frame

# Read in the reference file
in=reffile
i=1
while(fscan(in,tempreal1,tempreal2,tempreal3,tempreal4,tempreal5,tempreal6)!=EOF){
	yref[i]=tempreal1
	fwhm[i]=tempreal2
	order[i]=tempreal3
	a1[i]=tempreal4
	a2[i]=tempreal5
	a3[i]=tempreal6
#	print(yref[i])
	i+=1
	if(i>509){
		error(10,"Fibre array has run out of room!")
	}
}
num=i-1

# Read in the lines to mark
in=lines
i=1
while(fscan(in,temp)!=EOF){
	linearray[i]=temp
	i+=1
	if(i>101){
		error(10,"Line array has run out of room!")
	}
}

numlines=i-1

# Make up a file containing the xy coordinates of the lines

tempfile=mktemp("__temp__")

for(j=1; j<=numlines; j+=1){

	for(i=1; i<1024; i+=10){
		print(i," ", (a1[ linearray[j] ] + a2[ linearray[j] ] * i + a3[ linearray[j] ] * i * i), >> tempfile )
	}

tvmark(frame=p_frame, coords=tempfile, logfile="", autolog-, outimage="", deletions="", commands="", mark="point", color=204, pointsize=4)

delete(tempfile)
}
end


