###############################################################################
# Task to mark extraction apertures on an image
#

procedure markap(infile,dbase,reffile)

string infile {prompt="Image to have apertures marked"}
string dbase {prompt="Name of database directory"}
string reffile {prompt="Name of image used to find apertures"}

struct *in

begin
string p_infile, p_dbase, p_reffile
string apref, sub, junk, j1, j2, j3
struct line, j4
int len, pos, apnum
real apcrd, apx, apy

#############query parameters##################################################
p_infile=infile
p_dbase=dbase
p_reffile=reffile

##if p_dbase doesn't end in / then add one
len=strlen(p_dbase)
if(substr(p_dbase,len,len)!="/")
  p_dbase=p_dbase//"/"

##if p_reffile is fits extension then turn it into correct database format
len=strlen(p_reffile)
if(substr(p_reffile,len,len)=="]"){
  pos=stridx("[",p_reffile)
  sub=substr(p_reffile,pos+1,len-1)
  p_reffile=substr(p_reffile,1,pos-1)
  print("sub ",sub)
}

#put _ in correct place
print (sub) | translit("STDIN",",","_") | scan(sub)
sub="_"//sub//"_"

print ("sub ",sub)

apref=p_dbase//"ap"//p_reffile//sub
print("apref ",apref)

#display image in frame 1
display(p_infile,1)

in=apref

while(fscan(in,line)!=EOF){
  junk=fscan(line,j1,j2,j3)
  if(j1=="aperture"){
    apnum=int(j2)
  }
  if(j1=="center"){
    apx=real(j2)
    apy=real(j3)
    print(apx,apy) | tvmark(1,coords="STDIN",color=205,mark="plus",txsize=1)
  }
}


end
