/* Header file for a cut down version of the numerical recipes library */

#ifndef _NRROUTINES_
#define _NRROUTINES_

# if defined(_cplusplus)
extern "C" {
# endif

static float sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : (sqrarg)*(sqrarg))

void nrerror(char error_text[]);

void fit(float x[], float y[], int ndata, float sig[], int mwt,float *a, 
	 float *b, float *siga, float *sigb, float *chi2, float *q);

float gammq(float a, float x);

void gcf(float *gammcf, float a, float x, float *gln);

void gser(float *gamser, float a, float x, float *gln);

float gammln(float xx);

void spline(float x[], float y[], int n, float yp1, float ypn, float y2[]);
void splint(float xa[], float ya[], float y2a[], int n, float x, float *y);

float *vector(long nl, long nh);
void free_vector(float *v, long nl, long nh);

void lfit(float x[], float y[], float sig[], int ndat, float a[], int ia[],
	int ma, float **covar, float *chisq, void (*funcs)(float, float [], int));

void covsrt(float **covar, int ma, int ia[], int mfit);

void gaussj(float **a, int n, float **b, int m);

float **matrix(long nrl, long nrh, long ncl, long nch);

void free_matrix(float **m, long nrl, long nrh, long ncl, long nch);

int *ivector(long nl, long nh);

void free_ivector(int *v, long nl, long nh);



# if defined(_cplusplus)
}
# endif

#endif





