/* C Program ifudisp
**
** Draws an array of hexagons, scaling the value of each hexagon
** by an input data set
**
** AJ Dean. 30th March, 2000
*/

/* Version 2 AJ Dean 2nd April, 2001
** Rather than drawing hexagons, finds the nearest point in 
** the input grid and assigns the pixel its value
*/


#include <stdlib.h>
#include <math.h>
#include "fitswrap.h"

#define DISPSIZE 512

static float closest(int x, int y, float* gridx, float* gridy, 
		     float* gridvals, int numgrid, float thresh, float back);
static float distsq(int x1, int y1, float x2, float y2);
static int minmax(float* values, int nvals, float* min, float* max);

int main(int argc, char* argv[])
{

  float xspace=0;      /* x pixel spacing of points on grid */
  float yspace=0;      /* y pixel spacing of points on grid */  
  float* xgrid=0;      /* x values on arbitary ifu grid */
  float* ygrid=0;      /* y values on arbitary ifu grid */
  float* pixxgrid=0;   /* x grid values in pixels */
  float* pixygrid=0;   /* y grid values in pixels */
  float yoverx=0;      /* Ratio of the grid axes */
  float maxdist=0;     /* max dist object can be from centre in terms of x */
  
  float mingridx=0;       /* Size of the grid */ 
  float maxgridx=0;
  float mingridy=0;
  float maxgridy=0;
  float xgridsize=0;
  float ygridsize=0;
  float xgridmid=0;
  float ygridmid=0;

  int numlenses=0;      /* Number of lenses to be displayed */
  float* pixvals=NULL;  /* data values for the pixels */
  float* value=NULL;    /* Intensity in the lens */
  float offsetx=0;      /* Pixel values for middle of display */
  float offsety=0;
  float thresh=0.0;
  float back=0.0;

  int i=0;              /* Loop variables */
  int j=0;            

  FILE *fp;             /* For config file */
  long naxes[2];

  /* check for appropriate input */
  if ( argc < 2 ) {
    fprintf(stderr, 
	    "Usage: %s config_file \n", 
	    argv[0]);
    exit(1);
  }
    
  /* Allocate memory for the pixel values */
  if ((pixvals=(float *)malloc(DISPSIZE*DISPSIZE*sizeof(float))) == NULL ){
    
    printf("ifudisp: memory allocation for pixvals failed\n");
    exit(1);

  }
  
  /* open the input file and read in the files to stack */
  if ( (fp = fopen(argv[1],"r")) == NULL ){
    printf("Cannot open file containing list of files to be stacked\n");
    exit(1);
  }
    
  
  fscanf(fp,"%d %f %f",&numlenses,&yoverx,&maxdist);    
   
  /* Allocate memory for the ifu grid + values + pixel values*/
  /*  printf("%d\n",numlenses*sizeof(int)); */
  
  if ((xgrid=(float *)malloc(numlenses*sizeof(float))) == NULL ||
      (ygrid=(float *)malloc(numlenses*sizeof(float))) == NULL ||
      (value=(float *)malloc(numlenses*sizeof(float))) == NULL ||
      (pixxgrid=(float *)malloc(numlenses*sizeof(float))) == NULL ||
      (pixygrid=(float *)malloc(numlenses*sizeof(float))) == NULL ){
    
    printf("ifudisp: memory allocation for grid arrays failed\n");
    exit(1);
    
  }  

  for(i=0; i<numlenses; i++){
    fscanf(fp,"%f %f %f",xgrid+i,ygrid+i,value+i);
    /* printf("%f %f %f\n",*(xgrid+i),*(ygrid+i),*(value+i)); */
  }

  /* Close the input file containing the file list to be read in */
  fclose(fp); 

  /* Find out the size of the grid */

  if ( minmax(xgrid,numlenses,&mingridx,&maxgridx) ){
    printf("minmax routine failed!\n");
    exit(1);
  }

  if ( minmax(ygrid,numlenses,&mingridy,&maxgridy) ){
    printf("minmax routine failed!\n");
    exit(1);
  }
  
  /*printf("xmin=%f, xmax=%f, ymin=%f, ymax=%f\n",mingridx,maxgridx,mingridy,maxgridy);*/

  /* Find out which axis is longest and set spacing accordingly */

  xgridsize=maxgridx-mingridx;
  ygridsize=maxgridy-mingridy;
  xgridmid=(maxgridx+mingridx)/2;
  ygridmid=(maxgridy+mingridy)/2;

  /*printf("xmid %f, ymid %f\n",xgridmid,ygridmid);*/

  if ( xgridsize*yoverx > ygridsize ){

    xspace=(DISPSIZE)/(xgridsize+2);
    yspace=xspace*yoverx;

  } else {

    yspace=(DISPSIZE)/(ygridsize+2);
    xspace=yspace/yoverx;

  }

  offsetx=(DISPSIZE/2.0)-xgridmid*xspace;
  offsety=(DISPSIZE/2.0)-ygridmid*yspace;

  /*printf("offsetx=%f, offsety=%f,sum=%f\n",offsetx,offsety,(DISPSIZE-(yspace*(ygridsize+2))));*/
    
  /* Copy to the pixel grid */
  for( i=0; i<numlenses; i++){
    
    *(pixxgrid+i)=*(xgrid+i)*xspace+offsetx;
    *(pixygrid+i)=*(ygrid+i)*yspace+offsety;

  }

  /* Work out the max distance a pixel can be away from a centre */

  thresh=maxdist*xspace*maxdist*xspace; /* Distances are squared */
  /*printf("xspace=%f, yspace=%f, thresh=%f\n",xspace,yspace,thresh);*/

  /* Allocate a value to each pixel */

  for(j=0; j<DISPSIZE; j++){

    for(i=0; i<DISPSIZE; i++){

      *(pixvals+i+DISPSIZE*j) =
	closest(i, j, pixxgrid, pixygrid, value, numlenses, thresh, back);
    
    }
      
  }

 
  naxes[0]=naxes[1]=DISPSIZE;
  writefits_float_basic("!testout.fits", naxes, pixvals);
  

  free(xgrid);
  free(ygrid);
  free(pixvals);
  free(value);
  free(pixxgrid);
  free(pixygrid);

  return 0;

}

static float closest(int x, int y, float* gridx, float* gridy, 
		     float* gridvals, int numgrid,float thresh, float back)    
{

  int i=0;
  int currclosest=0;
  float currdist=0;
  float tempdist=0;
  
  currdist=distsq(x,y,*(gridx),*(gridy));

  for( i=1; i<numgrid; i++ ){

    tempdist=distsq(x,y,*(gridx+i),*(gridy+i));
    
    if( tempdist < currdist ){
      
      currdist=tempdist;
      currclosest=i;

    }
   
  } 
   
  return ( currdist <= thresh ? *(gridvals+currclosest) : back ); 

}

static float distsq(int x1, int y1, float x2, float y2)
{
  
  return ( ((float)(x1)-x2)*((float)(x1)-x2) + 
	   ((float)(y1)-y2)*((float)(y1)-y2) );

}



static int minmax(float* values, int nvals, float* min, float* max)
{

  int i=0;
  float mintemp=0;
  float maxtemp=0;

  mintemp=*(values);
  maxtemp=*(values);

  for(i=0; i<nvals; i++){
    
    if ( *(values+i) < mintemp ){
      mintemp=*(values+i);
    }
    
    if ( *(values+i) > maxtemp){
      maxtemp=*(values+i);
    }

  }

  *(min)=mintemp;
  *(max)=maxtemp;

  return 0;

}
