#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>
#include "matrix_solver.h"

#define SWAP(a,b) {dum=(a);(a)=(b);(b)=dum;}
#define TINY 1.0e-20;

int bandec (double **AA, int n, int m1, int m2, double **al, int *indx, double *d)
{
  int i=0,j=0,k=0,l=0;
  int mm=0;
  double dum=0,test=0;
  
  mm=m1+m2+1;
  l=m1;
  for(i=0;i<m1;i++){
    for(j=m1-i;j<mm;j++) AA[i][j-l]=AA[i][j]; 
    l--;
    for(j=mm-l-1;j<mm;j++) AA[i][j]=0.0;
  }
  *d=1.0;
  l=m1;
  for(k=0;k<n;k++){
    dum=AA[k][0];
    i=k;
    if(l<n)l++;
    for(j=k+1;j<l;j++){
      if(fabs(AA[j][0])>fabs(dum)){
	dum=AA[j][0];
	i=j;
      }
    }
    indx[k]=i;
    if(dum==0.0) AA[k][0]=TINY;
    if(i!=k){
      *d=-(*d);
      for(j=0;j<mm;j++) SWAP(AA[k][j],AA[i][j]);
    }
    for(i=k+1;i<l;i++){
      dum=AA[i][0]/AA[k][0];
      al[k][i-k-1]=dum;
      for(j=1;j<mm;j++) {
	AA[i][j-1]=AA[i][j]-dum*AA[k][j];
      }
      AA[i][mm-1]=0.0;
    }
  }
  return 0;
}

/*Solving tri-diagonal matrix*/

int tridiag(double *b, double *c, double *d, double *r, double *u, int numpk)
{
  /*numerical recipes p51*/
  
  double bet,gam[499];
  int j;

  /*gam=vector(0,numpk-1);*/
  if(c[0]==0.0) printf("%s\n","Error 1 in tridiag");
  u[0]=r[0]/(bet=c[0]);
  for(j=1;j<numpk;j++){
    gam[j]=d[j-1]/bet;
    bet=c[j]-b[j]*gam[j];
    if(bet==0.0) printf("%s","Error 2 in tridiag");
    u[j]=(r[j]-b[j]*u[j-1])/bet;
  }
  for(j=(numpk-2);j>=0;j--){
    u[j]-=gam[j+1]*u[j+1];
  }

  return 0;
}


int banbks(double **a, int n, int m1, int m2, double **al, int indx[], double *b)
{
  int i,k,l;
  int mm;
  double dum;
  
  mm=m1+m2+1;
  l=m1;
  for(k=0;k<n;k++){
    i=indx[k];
    if(i!=k) SWAP(b[k],b[i]);
    if(l<n) l++;
    for(i=k+1;i<l;i++) b[i]-=al[k][i-k-1]*b[k];
  }
  l=1;
  for(i=n-1;i>=0;i--){
    dum=b[i];
    for(k=1;k<l;k++) dum-=a[i][k]*b[k+i];
    b[i]=dum/a[i][0];
    if(l<mm) l++;
  }
  return 0;
}  


