
#include <stdlib.h>
#include "fitswrap.h"
#include "sumspec.h"
#include "specsort.h"

int main(int argc, char* argv[])
{

  int numhead=2;
  char* keywords[]={"YOVERX","MAXDIST"};
  float* keydata[2];
  float a=1.0;
  float b=2.0;
  int numcols;
  int numrows;
  int numfound=0;
  float** data=NULL;
  int j=0;
  int i=0;
  float** sumstuff=NULL;
  float** lensdata=NULL;
  int offset=0;
  int numlenses=0;

  *(keydata)=&a;
  (*(keydata+1))=&b;
  
  sumstuff=sumspec(argv[1],1,2010,&numfound);
  
  /*for(j=0; j<numfound; j++){

    printf("aperture %f  Sum %f\n", *((*sumstuff)+j), *( *(sumstuff+1)+j) );

  }
  */
  
  data=read_table(argv[1], 2, numhead, keywords, keydata, &numcols, 
       &numrows);
  /* 
     for(j=0; j<numrows; j++)
     printf("fibre id %f, xcord %f, ycord %f\n", *(*(data)+j), 
     *(*(data+1)+j), *(*(data+2)+j));
 */     


  lensdata=specsort(data, numrows, sumstuff, numfound, offset, &numlenses);


 
  /* Clean up */

 for(i=0;i<2; i++){
    free( *(lensdata+i) );
  }
  
  free(lensdata);


  for(i=0;i<numcols; i++){
    free( *(data+i) );
  }
  
  free(data);
    
  for(i=0; i<2; i++){
    free( *(sumstuff+i) );
  }
  
  free(sumstuff); 
  
  return 0;

}








