/* addapinfo.c 
 *
 * Program uses the first and last fibre on the detector to update the fits 
 * table extension. The extracted aperture numbers are added which correspond
 * to the lens positions and calibration fibres defined in the table header.
 * A J Dean. 11th June, 2001
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "libaddapinfo.h"

int main(int argc, char* argv[])
{


  int firstfibre=0;           /* First fibre on detector */
  int lastfibre=0;            /* Last fibre on detector */

  /* check for appropriate input */
  if ( argc < 4 ) {
    fprintf(stderr, 
	    "Usage: %s MEF-file first_fibre last_fibre\n", 
	    argv[0]);
    exit(1);
   }

  sscanf(argv[2],"%i",&firstfibre);
  sscanf(argv[3],"%i",&lastfibre);
  
  libaddapinfo(argv[1],firstfibre,lastfibre);


  return 0;

}




