/* apsort.c
 *
 * Uses the fibre configuration info and the output from findpos.c
 * to figure out which apertures correspond to which lenses on the IFU
 *
 * A J Dean 11th June, 2001 
 *
 */

#include "apsort.h"
#include "cirpass.h"

extern int apsort(int firstfibre, int lastfibre, float** configdata, 
		  float* apdata, int numrows)
{

  int i;
  int apnum=1;          /* Index for returned apnum */
  int fibrenum=1;       /* Index for fibres in slit */

  for( i=0; i<numrows; i++ ){

    if( fibrenum<firstfibre || fibrenum>lastfibre ){

      *(apdata+i)=MISSEDDET;
      fibrenum++;

    } else if ( *((*configdata)+i) == NOTINSLIT ){

      *(apdata+i)=NOTINSLIT;

    } else {

      *(apdata+i)=apnum;
      apnum++;
      fibrenum++;

    }
      
  }
  
  return 0;

}
