/* addfibreinfo.c
**
** Adds the CIRPASS ifu / fibre slit configuration to a MEF fits file.
** Should normally be run straight after stack
**
** Andrew J. Dean 5th April, 2001
**
*/

#include <stdlib.h>
#include "fitswrap.h"

int main(int argc, char* argv[])
{
  
  FILE *fp;            /* For config file */
 
  int numdata=0;
  int numhead=0;
  int numcol=0;

  float yoverx=0;
  float maxdist=0;
  float* fibreid=NULL;
  float* xgrid=NULL;
  float* ygrid=NULL;

  char* keywords[]={"YOVERX","MAXDIST"};
  char* colnames[]={"FibreID", "xcord", "ycord"};
  float* data[3];
  float* keydata[2];

  int i=0;

  /* Check for appropriate input */
  if (argc < 3) {
    fprintf(stderr, 
	    "Usage: %s ME-FITSfile config_file\n", 
	    argv[0]);
    exit(1);
  }

  /* open the config file */
  if ( (fp = fopen(argv[2],"r")) == NULL ){
    printf("Cannot open file containing configuration data\n");
    exit(1);
  }
    
  
  fscanf(fp,"%d %f %f",&numdata,&yoverx,&maxdist);    
 /* Allocate memory for the ifu grid + values*/
  
  if ((fibreid=(float *)malloc(numdata*sizeof(float))) == NULL ||
      (xgrid=(float *)malloc(numdata*sizeof(float))) == NULL ||
      (ygrid=(float *)malloc(numdata*sizeof(float))) == NULL ){
    
    printf("addfibreinfo: memory allocation for grid arrays failed\n");
    exit(1);
    
  }  
 
  for(i=0; i<numdata; i++){
    fscanf(fp,"%f %f %f",fibreid+i,xgrid+i,ygrid+i);
    /*printf("%f %f %f\n",*(fibreid+i),*(xgrid+i),*(ygrid+i));*/
  }

  /* Close the input file containing the file list to be read in */
  fclose(fp); 

  /* Insert into the fits file */

  data[0]=fibreid;
  data[1]=xgrid;
  data[2]=ygrid;

  keydata[0]=&yoverx;
  keydata[1]=&maxdist;

  numcol=3;
  numhead=2;

  if ( insert_table(argv[1],1,numhead,keywords, keydata, numcol, colnames, 
		    numdata, data) ){
    printf("addfibreinfo: insert_table failed");
    exit (1);
  }
 
  /* Clean up */

  free(fibreid);
  free(xgrid);
  free(ygrid);

  return 0;

}

