procedure szap (inlist,outlist)

# Cosmic ray zapper for 2D spectra.  This is really a front end for xzap
# at the moment.   First, the routine subtracts the sky from the 2D spectrum 
# using the 'background' task.  The skysubbed spectrum is then divided by 
# the square root of the sky of the sky to renormalize it to a constant
# rms, and then is xzapped to remove cosmic rays.  The user must set the
# desired parameters for xzap in advance!  The zapped image is then 
# re-multiplied by the sqrt normalization image to restore the counts,
# and the sky is optionally re-added back in again.
#
# Mark Dickinson, 23 Feb 95, roughly based on the old VISTA kastzap routine.

string	inlist	{prompt="Input spectra for zapping"}
string	outlist	{prompt="Zapped output spectra"}
bool	inter	{yes,prompt="Fit background interactively?"}
bool	restore	{yes,prompt="Restore sky to zapped spectrum?"}
bool	verbose	{yes,prompt="Verbose output?"}
struct	*inimglist
struct	*outimglist

begin

	string	ilist, olist
	string	infile, outfile
	string	img, outimg
	int 	nin

# Print disclaimer:

	print ("")
	print ("NOTE:   You must set desired parameters for the `background' task")
	print ("        and especially the `xzap' task manually before using this")
	print ("        routine! Many options for `background' may be set")
	print ("        interactively, however.")
	print ("")

# Get query parameters.

	ilist 	= inlist
	olist	= outlist

# Expand file lists into temporary files.

	infile =  mktemp("tmp$zap")
	outfile = mktemp("tmp$zap")
	sections (ilist,option="fullname",>infile)
	nin = sections.nimages
	sections (olist,option="fullname",>outfile)
	if (nin != sections.nimages) {
		print ("ERROR:   Numbers of input and output images do not match.")
		return
	}
	inimglist = infile
	outimglist = outfile

# Loop through input files:
	while (fscan(inimglist,img) != EOF) {

# Strip extension off input file name.
		fileroot (img,validim+)
		img = fileroot.root

# Read name of output file.
		if (fscan(outimglist,outimg) == EOF) {
			print ("ERROR:   Problem scanning output file name in xzap.")
			return
		}
		fileroot (outimg,validim+)
		outimg = fileroot.root

		if (verbose) print ("Working on ",img," ---ZAP!--> ",outimg)

# Subtract background.

		if (verbose) {
			print ("  ...fitting sky background...")
			if (inter) print ("     Please set `background'  parameters interactively:")
		}
		background (img,"_s"//img,inter=inter)

		if (verbose) print ("  ...making rms normalization image...")
		imarith (img,"-","_s"//img,"_sky"//img,verbose=verbose)
		imfunction ("_sky"//img,"_sqrt"//img,"sqrt",verbose=verbose)

		if (verbose) print ("  ...normalizing spectrum...")
		imarith ("_s"//img,"/","_sqrt"//img,"_norm"//img,verbose=verbose)

		if (verbose) print ("  ...xzapping cosmic rays...")
		xzap ("_norm"//img,"_znorm"//img,verbose=verbose)

		if (restore) {
			if (verbose) print ("  ...restoring sky to zapped spectrum...")
			imarith ("_znorm"//img,"*","_sqrt"//img,"_z"//img,verbose=verbose)
			imarith ("_z"//img,"+","_sky"//img,outimg,verbose=verbose)
			imrename ("crmask__norm"//img//".pl","crmask_"//img//".pl")
		   } else {
			if (verbose) print ("  ...un-renormalizing zapped spectrum...")
			imarith ("_znorm"//img,"*","_sqrt"//img,outimg,verbose=verbose)
			imrename ("crmask__norm"//img//".pl","crmask_"//img//".pl")
		}

		if (verbose) print ("  ...cleaning up...")
		img = img + fileroot.extension
		imdel ("_s"//img,ver-)
		imdel ("_sky"//img,ver-)
		imdel ("_sqrt"//img,ver-)
		imdel ("_norm"//img,ver-)
		imdel ("_znorm"//img,ver-)
		if (restore) imdel ("_z"//img,ver-)

	}

	inimglist 	= ""
	outimglist	= ""

end

