#
# Wrapper script to set up the nightly cirpass data directories
# on the data reduction and data store computers
#
# A. J. Dean 
#
# Last updated 26th Mar, 2003

procedure mktoday()

string rawdir {"cirpraw$", prompt="Root directory for the raw data"}
string reddir {"cirpred$", prompt="Root directory for the reduced data"}
string binpath {"CIRPBIN$../Scripts/", prompt="Path to maketoday.tcsh"}

begin

string raw, red, bin
string tempstr, tempstr1, therest
int pos, len

raw=rawdir
red=reddir
bin=binpath

# Load required packages 
utils

# Check if dirs contains any IRAF environment variables and
# decode them if they do

# raw #

  pos=0
  pos=stridx("$",raw)-1
  len=strlen(raw)
  if(pos>0){
    tempstr=substr(raw,1,pos)
    transenv(tempstr) | scan(tempstr1)
    pos=pos+2
    therest=substr(raw,pos,len)
    raw=tempstr1//therest
  }

  # remove any trailing /'s
  len=strlen(raw)
  if(substr(raw,len,len)=="/") {
    raw=substr(raw,1,len-1)
  }
  #print("raw ",raw)

# red #

  pos=0
  pos=stridx("$",red)-1
  len=strlen(red)
  if(pos>0){
    tempstr=substr(red,1,pos)
    transenv(tempstr) | scan(tempstr1)
    pos=pos+2
    therest=substr(red,pos,len)
    red=tempstr1//therest
  }
	
  # remove any trailing /'s
  len=strlen(red)
  if(substr(red,len,len)=="/") {
    red=substr(red,1,len-1)
  }
  #print("red ",red)

# bin #

  pos=0
  pos=stridx("$",bin)-1
  len=strlen(bin)
  if(pos>0){
    tempstr=substr(bin,1,pos)
    transenv(tempstr) | scan(tempstr1)
    pos=pos+2
    therest=substr(bin,pos,len)
    bin=tempstr1//therest
  }
  
  # remove any trailing /'s
  len=strlen(bin)
  if(substr(bin,len,len)=="/") {
    bin=substr(bin,1,len-1)
  }
  #print("bin ",bin)

maketoday(bin,raw)
makedata(bin,red)

cd red//"/today"
print("Current directory is now")
pwd

end


