# findpeaks.cl
#
# iraf wrapper to the c programs peakfind and specmark
#
# Takes a cut through the input image and finds the positions of peaks 
# within the cut, used to identify the calibration fibres in cirpass images
#
# A. J. Dean., 23rd July, 2001.

procedure locatepeaks(imagefile, xline, innoise, insigma, outputfile)

string imagefile {prompt="Input file"}
int    xline     {512,prompt="Line to use as cut through image"}
real   innoise   {10,prompt="Background noise in image"}
real   insigma   {30,prompt="Sigma above background which constitutes a line"}
string outputfile{prompt="File to write out positions to"}

begin

 	string imfile, outfile, tempfile
	int line,len
	real noise,sigma
	
	imfile=imagefile
	line=xline
	noise=innoise
	sigma=insigma
	outfile=outputfile

# Load required packages

	utils

# check for .fits on the end

        len=strlen(imfile)
        if(substr(imfile,len-4,len)!=".fits") {
                imfile=imfile//".fits"
        }

	display(imfile//"[sci,1]",1)
	peakfind(imfile,line,noise,sigma,outfile)
	tempfile=mktemp("__temp__")
	imcopy(imfile//"[sci,1]["//line//",*]",tempfile)
	specmark_no_wav(tempfile//".fits",outfile)

	imdel(temp)

end



