# idisplay.cl	15th June, 2001
#
# iraf script to display the IFU image from input extracted spectra
# and then allow you to pick a lens from ifu image and splot its spectrum
#
# report bugs, comments to ajd@ast.cam.ac.uk

procedure idisplay (meffile,startpixel,endpixel,ohmaskfile)

string meffile {prompt = "extract output file"}
# bool domark {yes, prompt="Mark bad pixel selections?"}
# int frame   {1, prompt="Display frame to be marked on"}
int startpixel {1, prompt="starting pixel to sum spectra over"}
int endpixel   {1024, prompt="final pixel to sum spectra over"}
bool domedian {no, prompt="Median the ms file to improve contrast?"}
bool doohmask {no, prompt="Multiply by an oh mask file?"}
string ohmaskfile {prompt="MEF file containing the oh mask"}
string outputfile {"ifuimage.fits", prompt="IFU image output file"}
string specrootname {"lensid", prompt="Group name to imcopy picked lenses to"}
string ohrootname {"oh", prompt="Group name to imcopy oh lenses to"}
string ppickfile {"fred", prompt="File to scopy spectra out of when p is pressed"}
string pohpickfile {"fred", prompt="File to scopy the oh spectra out of"}
bool interactive {yes, prompt="Run in interactive mode?"}

begin
	string imfile, tempfile, specname, lensesout, pfile, pohfile, ohname
        string tempfile2, maskfile, tempfile3, tempfile4
	char again = 'r'
        real xc, yc
        int i, xpix, ypix, len, aperturenum
        int startpix
	int endpix
	bool exist, domed, domask, inter
	real immedian	
	
	imfile = meffile
	startpix = startpixel
	endpix = endpixel
	domed = domedian
	domask = doohmask
	inter=interactive

	if(domask){

		maskfile = ohmaskfile

	}

#	tempfile=mktemp("_temp_")
#	tempfile=tempfile//".fits"

	tempfile=outputfile
	exist=access(tempfile)
	if(exist){
		delete(tempfile)
	}

	
	specname=specrootname
	ohname=ohrootname
	pfile=ppickfile
	pohfile=pohpickfile

# keep scan happy!
	immedian=0

# load required packages

utils

# check for .fits on the end

	len=strlen(imfile)
	if(substr(imfile,len-4,len)!=".fits") {
		imfile=imfile//".fits"
	}	

	if(domed){
		tempfile2=mktemp("_temp_")
		tempfile2=tempfile2//".fits"
		mefmedian(imfile,tempfile2,i_xmed=30, i_ymed=1)
		
		if(domask){
			
			tempfile3=mktemp("_temp_")
			tempfile3=tempfile3//".fits"
			tempfile4=mktemp("_temp_")
			tempfile4=tempfile4//".fits"
			print("Multiplying by ",maskfile)
			imarith(tempfile2//"[sci,1]","*",maskfile//"[sci,1]",
				tempfile3)
			makemef(imfile,tempfile3,tempfile4)
			ifudisplay(tempfile4,tempfile,startpix,endpix)
			imdelete(tempfile2)
			imdelete(tempfile3)
			imdelete(tempfile4)

		} else {

			ifudisplay(tempfile2,tempfile,startpix,endpix)
			imdelete(tempfile2)

		}

	} else {
		
		if(domask){
			tempfile2=mktemp("_temp_")
			tempfile2=tempfile2//".fits"
			tempfile3=mktemp("_temp_")
			tempfile3=tempfile3//".fits"
			print("Multiplying by ",maskfile)
			imarith(imfile//"[sci,1]","*",maskfile//"[sci,1]",
				tempfile2)
			makemef(imfile,tempfile2,tempfile3)
			ifudisplay(tempfile3,tempfile,startpix,endpix)
			imdelete(tempfile2)
			imdelete(tempfile3)
		
		} else {
	
			ifudisplay(imfile,tempfile,startpix,endpix)	
		}

	}

#	display(tempfile//"[sci,1]",frame=1,zmask=tempfile//"[sci,1]")

	display(tempfile//"[sci,1]",frame=2)
	if(inter){
	print("\nidisplay: Press s for spectra, w to change wavelength range,")
	print("i to enter imexam, p to imcopy lens spectrum to spectrum file")
	print(specname//"_lens_"//"lensnumber, q to quit.")
	print("NB: w only works if you've run idisplay directly")
        while (again == 'r') {
        
	   i = fscan(imcur, xc, yc, again, again)

           if (frac(xc) < 0.5) xpix = int(xc)
           else xpix = int(xc) + 1
           if (frac(yc) < 0.5) ypix = int(yc)
           else ypix = int(yc) + 1
 
           switch (again) {
               case 's':
               {
		  
		  # print("pixel is ",xc," ",yc)
		  findap(imfile,xc,yc) | scan(aperturenum)
		  if(aperturenum >= 0){
		 	splot(imfile//"[sci,1][*,"//aperturenum//"]")
		  } else {
			print("No spectrum available")
                  }
	
               }


	       case 'w':
	       {

		startpix = startpixel
		endpix = endpixel
		delete(tempfile)
		ifudisplay(imfile,tempfile,startpix,endpix)
		display(tempfile//"[sci,1]",frame=2)

	       }	

	       case 'p':
	       {

	          findap(imfile,xc,yc) | scan(aperturenum)
		  if(aperturenum >= 0){

			exist=access(specname//"_lens_"//aperturenum//".fits")
			
			if(exist){
				print("idisplay: Error! File already exists!")
			} else {
				scopy(imfile//"[sci,1][*,"//aperturenum//"]", specname//"_lens_"//aperturenum)
			#	imcopy(imfile//"[sci,1][*,"//aperturenum//"]", specname//"_lens_"//aperturenum)	
			#	scopy(pfile//"[*,"//aperturenum//"]", specname//"_lens_"//aperturenum,verb+)
			#	scopy(pohfile//"[*,"//aperturenum//"]", ohname//"_lens_"//aperturenum,verb+)

				imstat(specname//"_lens_"//aperturenum, fields="midpt", format-) | scan immedian

				if(immedian<0){

					imdel(specname//"_lens_"//aperturenum)
				#	imarith(imfile//"[sci,1][*,"//aperturenum//"]","*",-1,specname//"_lens_"//aperturenum)
				#	sarith(pfile//"[*,"//aperturenum//"]","*",-1,specname//"_lens_"//aperturenum)
					sarith(imfile//"[sci,1][*,"//aperturenum//"]","*",-1,specname//"_lens_"//aperturenum)
				}

			}

		  } else {
			print("No spectrum available")
              	  }
		
               }

	       case 'i':
	       {
		print("*****Entering imexam, press q to quit *****")
		imexam
		print("**************Leaving imexam***************")
		print("**********Press q to quit idisplay*********")

	       }

               case 'q':
                  break

               default:
                  print ("Unknown key\n") 
           }   
           if (again != 'q') again = 'r'           
        }
	
	} # matches interactive        

end

