##############################################################################
# task gain                                                                  #
#                                                                            #
# Takes an input list of ME-FITS files produced by the pipeline and          #
# determines the gain and readnoise at each pixel                            #
#                                                                            #
# A. J. Dean 8th Jan, 2001                                                   #
#                                                                            #
##############################################################################

procedure gain(filelist,flatfield,outfile,data,xcord,ycord,sec,graph)

string filelist  {prompt="File with list of ME-FITS files of same exposure and reads"}
string flatfield {prompt="Flatfield file | none"}
string outfile   {prompt="Output gain and readnoise filename (something.fits)"}
bool   data      {prompt="Keep the intermediate mean / var data files? [yes/no]"}
string outdata   {prompt="Filename root for intermediate data files"}
int    xcord     {prompt="Top x pixel to look at"}
int    ycord     {prompt="Top y pixel to look at"}
string sec       {prompt="Section to use in stats"}
bool   graph     {prompt="Graphical output? [yes/no] (.ps file otherwise)"}
string psfile    {mode="a", prompt="Output filename for the postscript file"}

begin

	string ffilelist, fflatfield, foutfile, section
	string tempstr, tempflat, tempmean, tempsig, fpsfile, foutdata
	int i, nexn, nextend, nsci, numfiles, x, y	
	bool dograph, dodata

# Number of extensions per imset, should really be a package paramater! 
	nexn=4

	ffilelist  = filelist
	fflatfield = flatfield
	foutfile   = outfile
	dodata     = data

	if (dodata){
	
		foutdata=outdata
		
	} else {

	foutdata = mktemp("_temp_")

	}
	
	x 	   = xcord
	y 	   = ycord	
	section    = sec
	dograph    = graph
	
	if (!dograph){
		fpsfile=psfile
	}

# Load required packages

	utils

# Call the C program which does the actual work

	print("Calculating mean / var for set of images and fitting slope to each pixel individually")

	if(dograph){
		
		c_gain(ffilelist,fflatfield,foutfile,x,y,foutdata)
		
	} else {

		c_gain(ffilelist,fflatfield,foutfile,x,y,foutdata,fpsfile)

	}

# Calculate statics on the desired section

	print("Calculating mean / var for the required image section")
	analyse_gain(foutdata,section)

# Clean up

	if(!dodata){
		delete(foutdata//"_mean_*.fits")
		delete(foutdata//"_var_*.fits")
	}

end





