###############################################################################
# task dotarget
#
# Data reduction pipeline for target observations
#
# doschmidt or docirpass should be run first
#
# this task does (will do)
# sky subtraction
# spectral extraction
# (making datacube)
###############################################################################

procedure dotarget(targetname)

string targetname {prompt="MEF file containing target observation processed through docirpass"}
string extracttype="sum" {mode="lh",prompt="Extraction type", enum="sum|opt"}
bool writejpeg=NO {mode="lh", prompt="Write out jpeg image of ifu image?"}
bool interactive {yes, prompt="Run in interactive mode?"}

struct *in

begin

string p_targetname,targetph,exth,extname[4],tempstr,temp1,temp2, temp3, temp4
string temp5, temp6
string checkname[4]="SCI","VAR","DQ","TIME"
string extrname, sub, outfile, calroot,ext,fitsname,therest
string zoffcorr, maskcorr, noiscalc, timecalc, lincorr, unitcorr
string maskfile, noisfile, linfile, cridcalc
string dbfile,bkgfile,extrfile,wvfile,flatfile,calfile,bkgcorr
string dowvcal,dowvalgn,flatcorr,doflcal,realname,doextr
string calout,caloutroot,caloutph,fname,frunno
string tempfile,bkgph
string ajdtempfile
struct logicvals, values, exttype
int nexn,totexn,pos,inc,len,junk,startex,bintrue,totexn1,tableext
int correxn,istart,iend, arrind,lenf
real rnexn
bool zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc
bool extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc,datred,wrongtotexn=no
bool writejpg, exist, inter

#########################load required packages############################
fitsutil

#########################query parameters######################################
p_targetname=targetname
exttype=extracttype
writejpg=writejpeg
inter=interactive

#########################constant variables####################################
#nexn is expected number of extensions per imset
nexn=cirpasspars.nexn
#checkname is string array containing expected extension names (read from
#cirpasspars.par
checkname[1]=cirpasspars.sciname
checkname[2]=cirpasspars.varname
checkname[3]=cirpasspars.dqname
checkname[4]=cirpasspars.timname

# check for .fits on the end ** AJD change **
        lenf=strlen(p_targetname)
        if(substr(p_targetname,lenf-4,lenf)!=".fits") {
                p_targetname=p_targetname//".fits"
        }


##set primary header variable
targetph=p_targetname//"[0]"

##set file name for final images (ie possibly background subtracted)
##assume that input is _ima file
##output file will have _cal instead of _ima
pos=stridx(".",p_targetname)
lenf=strlen(p_targetname)
if(pos>1){
  sub=substr(p_targetname,1,pos-5)
}
else{
  ## ** AJD Change ** if pos<1 then pos-4 is negative! ##
  # fixed by always checking for .fits at start
  # sub=substr(p_targetname,1,pos-4);
  print("AJD thought we should never reach here! Something's gone wrong ...")
}

calroot=sub//"_cal"
calout=calroot//".fits"

##if this file exists then increase number ie _cal.1.fits
inc=1
while(access(calout)){
  calout=calroot//"."//inc//".fits"
  inc+=1
}
caloutph=calout//"[0]"
print("dotarget: Output image files ",calout)

##assuming that extension required to extract spectra is [sci,1]
##add this to targetname to give extrname (name of file to extract spectra
##from)
extrname=calout//"[sci,1]"
#print("Extracting spectra from ",extrname)

##set extracted spectra outfile name by removing .fits (if it exists) 
##and adding .ms
outfile=calroot//".ms.fits"
##if this file exists then increase number ie .ms.1
inc=1
while(access(outfile)){
  outfile=calroot//".ms."//inc//".fits"
  inc+=1
}
#print("outfile ",outfile)

#########################checks################################################
#check this is a multiextension fits file with the expected number and name
#of extensions

##check if first extension is binary table extension (not required)
##save whether it is or not in tableext
##check using whether totexn is divisible by nexn (= number of
##extensions in imset
tableext=0

#read total number of extensions from nextend kword in primary header
hselect(targetph,"nextend",yes) | scan(totexn)

##have a real version of nexn
rnexn=real(nexn)
if(int(totexn/rnexn)!=totexn/rnexn)
  tableext=1
#read extension names from first tableext+1 -> tableext+nexn extensions
istart=1+tableext
iend=nexn+tableext
for(i=istart;i<=iend;i+=1){
  arrind=i-tableext
  exth=p_targetname//"["//str(i)//"]"
  hselect(exth,"extname",yes) | scan(extname[arrind])
}

##exit if any extension isn't as expected
##NOTE this assumes extensions are always in the same order, perhaps not
##necessary to assume this ?
for(i=istart;i<=iend;i+=1){
  arrind=i-tableext
  if(extname[arrind]!=checkname[arrind]){
    error(10,"extension number "//i//" has name "//extname[arrind]//" not "//checkname[arrind])
  }
}


##if greater than nexn+tableext extensions then print a warning and only use
##first nexn+tableext extensions
##define temp1 here so variable always exists, makes it easier to delete
##temp file
temp1=mktemp("temp")//".fits"
correxn=nexn+tableext

if(totexn>correxn){
  wrongtotexn=yes
#  realname=p_targetname
  print("##################WARNING!############################")
  print("File contains ",totexn," extensions.")
  print("This is more than the expected ",correxn," extensions.")
  print("The calibration will just use the first ",correxn," extensions.")
##create file containing first nexn extensions from p_targetname
##tempstr is variable that contains list of extensions to be copied
##NB although syntax 0-5 is meant to copy 0,1,2,3,4,5 it appears
##to just copy 0,5
  tempstr="0"
  for(i=1;i<=correxn;i+=1){
    tempstr=tempstr//","//str(i)
  }
  print("tempstr",tempstr)
  fxcopy(p_targetname,temp1,tempstr,new_file+,verbose-)
  print("######################################################")
##p_targetname is now nexn extension file
  p_targetname=temp1
  tempstr=temp1//"[0]"
  hedit(tempstr,"nextend",correxn,add-,delete-,verify-,show-,update+)
}

####################get required data reduction header kwords##################
##annoyingly have to set all variables to something before can read
##correct value into them using scan. otherwise it complains about
##undefined variables
zoffcorr="notset"
maskcorr="notset"
noiscalc="notset"
timecalc="notset"
lincorr="notset"
unitcorr="notset"
bkgcorr="notset"
doextr="notset"
dowvcal="notset"
dowvalgn="notset"
flatcorr="notset"
doflcal="notset"
cridcalc="notset"
maskfile="notset"
noisfile="notset"
linfile="notset"
bkgfile="notset"
extrfile="notset"
dbfile="notset"
wvfile="notset"
flatfile="notset"
calfile="notset"

##read values of required data reduction kwords from primary header
hselect(targetph,"zoffcorr",yes) | scan(zoffcorr)
hselect(targetph,"maskcorr",yes) | scan(maskcorr)
hselect(targetph,"noiscalc",yes) | scan(noiscalc)
hselect(targetph,"timecalc",yes) | scan(timecalc)
hselect(targetph,"lincorr",yes) | scan(lincorr)
hselect(targetph,"unitcorr",yes) | scan(unitcorr)
hselect(targetph,"bkgcorr",yes) | scan(bkgcorr)
hselect(targetph,"doextr",yes) | scan(doextr)
hselect(targetph,"dowvcal",yes) | scan(dowvcal)
hselect(targetph,"dowvalgn",yes) | scan(dowvalgn)
hselect(targetph,"flatcorr",yes) | scan(flatcorr)
hselect(targetph,"doflcal",yes) | scan(doflcal)
hselect(targetph,"cridcalc",yes) | scan(cridcalc)
hselect(targetph,"maskfile",yes) | scan(maskfile)
hselect(targetph,"noisfile",yes) | scan(noisfile)
hselect(targetph,"linfile",yes) | scan(linfile)
hselect(targetph,"bkgfile",yes) | scan(bkgfile)
hselect(targetph,"extrfile",yes) | scan(extrfile)
hselect(targetph,"dbfile",yes) | scan(dbfile)
hselect(targetph,"wvfile",yes) | scan(wvfile)
hselect(targetph,"flatfile",yes) | scan(flatfile)
hselect(targetph,"calfile",yes) | scan(calfile)
#print("after reading from header doextr=",doextr)

###############check logic of data reduction keywords##########################
print("Checking logic of required data reduction steps\n");
_logic_check(targetname=p_targetname,nexn=nexn,zoffcorr=zoffcorr,maskcorr=maskcorr,noiscalc=noiscalc,timecalc=timecalc,lincorr=lincorr,unitcorr=unitcorr,cridcalc=cridcalc,bkgcorr=bkgcorr,doextr=doextr,dowvcal=dowvcal,dowvalgn=dowvalgn,flatcorr=flatcorr,doflcal=doflcal,maskfile=maskfile,noisfile=noisfile,linfile=linfile,bkgfile=bkgfile,extrfile=extrfile,dbfile=dbfile,wvfile=wvfile,flatfile=flatfile,calfile=calfile,bkgchk=yes,extrchk=yes,flatchk=yes)

logicvals=_logic_check.outlogic
junk=fscan(logicvals,zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc,extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc)
#print("after logic check bkglgc =",bkglgc," extrlgc =",extrlgc)

#####checking data reduction files exist and are of required type/format######
###background subtraction
##check bkg file has correct first nexn extension if not set bkglgc=no

if(bkglgc){
  bkgph=bkgfile//"[0]"
#check if bkg file has binary table extension
  tableext=0
  hselect(bkgph,"nextend",yes) | scan(totexn1)
  if(int(totexn1/rnexn)!=totexn1/rnexn)
    tableext=1
#read extension names from first nexn extensions
  for(i=1;i<=nexn;i+=1){
    ext=tableext+i
    exth=bkgfile//"["//ext//"]"
    hselect(exth,"extname",yes) | scan(extname[i])
  }
  for(i=1;i<=nexn;i+=1){
    if(extname[i]!=checkname[i]){
      print("extension number "//i//" in "//bkgfile//" has name "//extname[i]//" not "//checkname[i]//".\nBackground correction will be OMITTED")
      bkglgc=no
    }
  }
}
 
##ADD checking bkg file has one imset if not print warning

# Done in _logic_check
##Check flat field file exists
#if(flatlgc){
#	len=strlen(flatfile)
#        	if(substr(flatfile,len-4,len)!=".fits") {
#                	flatfile=flatfile//".fits"
#        	}
#	exist=access(flatfile)
#	if(!exist){
#		print("Flatfield file ",flatfile, "does not exist!")
#		print("Flatfielding will not be performed!")
#		flatlgc=0
#	} else {
#		print("Flatfielding will be performed with", flatfile)
#	}
#}

##ADD check wavelength calibration file exists

##make final datred logical value
datred=(bkglgc) || (wvcallgc) || (wvalgnlgc) || (flatlgc) || (flcallgc)
#print("datred is ",datred)

#########################do data reduction#####################################
##background image subtraction
if(bkglgc){
  print("Performing Background subtraction")
  mefarith(p_targetname,"-",bkgfile,calout)
  p_targetname=calout
}
else{
  print("OMITTING Background subtraction\n")
}

if(flatlgc){
# AJD Gemini-S addition, as yet untested
   print("Performing Flat fielding with file ", flatfile)
   ajdtempfile=mktemp("__temp__")
   ajdtempfile=ajdtempfile//".fits"
   mefarith(p_targetname,"/",flatfile,ajdtempfile)
   delete(p_targetname)
   fxcopy(ajdtempfile,calout,groups="",new_file+)
   delete(ajdtempfile)
   p_targetname=calout
}
else{
  print("OMITTING Flat fielding\n")
}

##if no data reduction was carried out then create calout
#if(!datred)
#  fxcopy(p_targetname,calout,groups="",new_file+)

# Wavelength calibration complicates the above if(!datred), hence this
# approach added by AJD at Gemini-S
exist=access(calout)
if(!exist)
  fxcopy(p_targetname,calout,groups="",new_file+)

##extract spectra
#ADD if extrlogic
if(extrlgc){
  print("Extracting spectra from ",calout," using spectra position information in ",extrfile,". Output file ",outfile,".")
  optextract_float(calout,outfile,exttype,extrfile)
}
else{
  print("OMITTING Spectral extraction\n");
}

if(wvcallgc){
  print("Performing Wavelength calibration")
  ajdtempfile=mktemp("__temp__")
  ajdtempfile=ajdtempfile//".ms.fits"
  wvcal(outfile,wvfile,ajdtempfile)
  delete(outfile)
  fxcopy(ajdtempfile,outfile,groups="",new_file+)
  delete(ajdtempfile)
}
else{
  print("OMITTING Wavelength calibration\n")
}

#################set data reduction history keywords###########################
if(bkglgc){
  hedit(caloutph,"bkgdone","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(caloutph,"bkgdone","OMITTED",add-,delete-,verify-,show-,update+)
}
if(flatlgc){
  hedit(caloutph,"flatdone","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(caloutph,"flatdone","OMITTED",add-,delete-,verify-,show-,update+)
}
if(wvcallgc){
  hedit(caloutph,"wvcldone","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(caloutph,"wvcldone","OMITTED",add-,delete-,verify-,show-,update+)
}
if(extrlgc){
  hedit(caloutph,"extrdone","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(caloutph,"extrdone","OMITTED",add-,delete-,verify-,show-,update+)
}

# If we make a .ms file, then update its header too:

if(extrlgc){

	if(bkglgc){
  	  hedit(outfile,"bkgdone","PERFORMED",add-,delete-,verify-,show-,
	  update+)
	}
	else{
  	  hedit(outfile,"bkgdone","OMITTED",add-,delete-,verify-,show-,update+)
	}
	if(flatlgc){
  	  hedit(outfile,"flatdone","PERFORMED",add-,delete-,verify-,show-,
	  update+)
	}
	else{
  	  hedit(outfile,"flatdone","OMITTED",add-,delete-,verify-,show-,
 	  update+)
	}
	if(wvcallgc){
  	  hedit(outfile,"wvcldone","PERFORMED",add-,delete-,verify-,show-,
	  update+)
	}
	else{
  	  hedit(outfile,"wvcldone","OMITTED",add-,delete-,verify-,show-,
	  update+)
	}
	if(extrlgc){
  	  hedit(outfile,"extrdone","PERFORMED",add-,delete-,verify-,show-,
	  update+)
	}
	else{
  	  hedit(outfile,"extrdone","OMITTED",add-,delete-,verify-,show-,
	  update+)
	}
}

##################Display output ##############################################

if(bkglgc){
	display(calout//"["//checkname[1]//",1]",1)
}

if(extrlgc){

	if(inter){
		idisplay(outfile,startpixel=1,endpixel=1024)
	}
	if(writejpg){
		temp3=mktemp("_temp_")//".fits"
		temp4=mktemp("_temp_")//".fits"
		temp5=mktemp("_temp_")//".jpg"
		temp6=mktemp("_temp_")//".jpg"
		#imcopy("ifuimage[sci,1][*,130:385]", temp3, verb-)
		imcopy("ifuimage[sci,1]", temp3, verb-)
		imcopy(calout//"[sci,1]", temp4, verb-)
		print("Writing "//sub//"_ifuimage.jpg")
		# Letters are 10 pixels wide
		len=strlen(sub)
		convert("-quality 100",
			"-pointsize 20", "-pen white", 
			# "-equalize", "+contrast",
			"-level 0,2,65000",
			"-draw \'text "//256-len*10/2//",80 \""//sub//"\"\'", 
		 	 temp3, temp5)
		convert("-geometry 512x512", "-quality 100", "-equalize",
		#	"-level 0,3,65000", 
			temp4, temp6)
		montage("-quality 100", "-geometry 512x512", 
			"-tile 2x1", temp5, temp6, sub//"_ifuimage.jpg")
		delete(temp3)
		delete(temp4)
		delete(temp5)
		delete(temp6)
	}

}

##################tidy up######################################################
if(access(temp1))
  imdelete(temp1)

end
