###############################################################################
# Data reduction pipeline for Cirpass - docirpass modified for Gemini
# Works on _raw files produced and then renamed for Gemini
#
# Created by Andrew J Dean 17th March, 2003
##############################################################################

procedure dogemini(imagename,update)

string imagename {prompt="Image name"}
string bkgfile_gem {prompt="Background file to subtract"}
string extrfile_gem {prompt="File containing fibre position information for extraction"}
string zoffcorr_gem {prompt="Subtract the bias frame", enum="PERFORM|OMIT"}
string cridcalc_gem {prompt="Remove cosmic rays?", enum="PERFORM|OMIT"}
string bkgcorr_gem {prompt="Subtract a background frame?", enum="PERFORM|OMIT"}
string doextr_gem {prompt="Extract the spectra?"}
bool update {prompt="Update the data reduction keywords in the headers?"}
bool   interactive {yes, prompt="Run in interactive mode?"}

struct *in {mode="h"}

begin

struct logicvals
string name
string fname,frunno,fdateobs,fstackno
string rawdir,reddir,file1,rawfile,stackout,readno,tempfile,outfile
string tempfile1,stackph
string zoffcorr,maskcorr,noiscalc,timecalc,lincorr,unitcorr,bkgcorr
string doextr,dowvcal,dowvalgn,flatcorr,doflcal,cridcalc
string maskfile,noisfile,linfile,bkgfile,extrfile,wvfile,flatfile,calfile
string dbfile, imaout,imaoutroot,imaph,ans, cfgfile
string sciname,tempstr,therest,tempstr1
real gain,readnoise
int nexn,len,beg,nloops,nreads,ifstackno,totnum,inc,junk,pos
bool rawexist,redexist,stackexist,rawdatexist
bool zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc
bool extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc,datred
bool doaverage, inter

string cirpname
string p_bkgfile, p_extrfile
string p_zoffcorr, p_cridcalc, p_bkgcorr, p_doextr
bool up_head

p_bkgfile=bkgfile_gem
p_extrfile=extrfile_gem
p_zoffcorr=zoffcorr_gem
p_cridcalc=cridcalc_gem
p_bkgcorr=bkgcorr_gem
p_doextr=doextr_gem

#########################query parameters#####################################
#except stack no
name=imagename
up_head=update
inter=interactive

########################constant variables####################################
#set in cirpasspars.par
nexn=cirpasspars.nexn
sciname=cirpasspars.sciname

##########################set up procedures####################################
##load required packages
fitsutil
utils

# Gemini main changes - update the headers to those requested by the user
# and rename the file to the original cirpass convention

# Check for .fits on the end
len=strlen(name)
        if(substr(name,len-4,len)!=".fits") {
                name=name//".fits"
        }

if(!access(name)){
	error(10,"Input image ", name, " does not exist, can't do anything!")
}

cirpname="notset"
hselect(name//"[0]","CIRPNAME",yes) | scan (cirpname)

# Create the cirpass expected file
print("Original cirpass filename was ", cirpname, " creating file")
if(access(cirpname)){
  print("\n***** A file already exists with the correct cirpass name *****")
  print("***** Assuming this file is correct and continuing as normal *****")
  print("***** The _ima files will have automatically incremented numbers *****\n")
} else {
fxcopy(name, cirpname, groups="", new_file+, verb+)
}

# Change back to our naming convention (these variable would have
# been set during stacking in docirpass.cl).

stackout=cirpname
stackph=stackout//"[0]"

len=strlen(stackout)
imaoutroot=substr(stackout,1,len-8)
imaoutroot=imaoutroot//"ima"
imaout=imaoutroot//".fits"

# Sort out the headers

if(up_head){

	print("dogemini: Updating data reduction pipeline keywords in ",
	      stackph)
	hedit(stackph,"BKGFILE",p_bkgfile,add-,delete-,verify-,show-,update+)
	hedit(stackph,"EXTRFILE",p_extrfile,add-,delete-,verify-,show-,update+)
	hedit(stackph,"ZOFFCORR",p_zoffcorr,add-,delete-,verify-,show-,update+)
	hedit(stackph,"CRIDCALC",p_cridcalc,add-,delete-,verify-,show-,update+)
	hedit(stackph,"BKGCORR",p_bkgcorr,add-,delete-,verify-,show-,update+)
	hedit(stackph,"DOEXTR",p_doextr,add-,delete-,verify-,show-,update+)
}

##############get data reduction keywords from header#########################
print("Reading data reduction keywords from header ",stackph)
##annoyingly have to set all variables to something before can read
##correct value into them using scan. otherwise it complains about
##undefined variables
zoffcorr="notset"
maskcorr="notset"
noiscalc="notset"
timecalc="notset"
lincorr="notset"
unitcorr="notset"
bkgcorr="notset"
doextr="notset"
dowvcal="notset"
dowvalgn="notset"
flatcorr="notset"
doflcal="notset"
cridcalc="notset"
maskfile="notset"
noisfile="notset"
linfile="notset"
bkgfile="notset"
extrfile="notset"
dbfile="notset"
wvfile="notset"
flatfile="notset"
calfile="notset"

hselect(stackph,"zoffcorr",yes) | scan(zoffcorr)
hselect(stackph,"maskcorr",yes) | scan(maskcorr)
hselect(stackph,"noiscalc",yes) | scan(noiscalc)
hselect(stackph,"timecalc",yes) | scan(timecalc)
hselect(stackph,"lincorr",yes) | scan(lincorr)
hselect(stackph,"unitcorr",yes) | scan(unitcorr)
hselect(stackph,"bkgcorr",yes) | scan(bkgcorr)
hselect(stackph,"doextr",yes) | scan(doextr)
hselect(stackph,"dowvcal",yes) | scan(dowvcal)
hselect(stackph,"dowvalgn",yes) | scan(dowvalgn)
hselect(stackph,"flatcorr",yes) | scan(flatcorr)
hselect(stackph,"doflcal",yes) | scan(doflcal)
hselect(stackph,"cridcalc",yes) | scan(cridcalc)
hselect(stackph,"maskfile",yes) | scan(maskfile)
hselect(stackph,"noisfile",yes) | scan(noisfile)
hselect(stackph,"linfile",yes) | scan(linfile)
hselect(stackph,"bkgfile",yes) | scan(bkgfile)
hselect(stackph,"extrfile",yes) | scan(extrfile)
hselect(stackph,"dbfile",yes) | scan(dbfile)
hselect(stackph,"wvfile",yes) | scan(wvfile)
hselect(stackph,"flatfile",yes) | scan(flatfile)
hselect(stackph,"calfile",yes) | scan(calfile)

hselect(stackph,"gain",yes) | scan(gain)
hselect(stackph,"readnois",yes) | scan(readnoise)

##############check logic of data reduction keywords##########################
##add following parameters=yes to _logic_check to check logic. 
##zoffchk=no,maskchk=no,noischk=no,timechk=no,linchk=no,unitchk=no,cridchk=no
##Not all of these steps need any logic checking.
##_logic_check only checks logic if corresponding lgc parameter (which
##it finds) is yes

print("Checking logic of required data reduction steps\n");

_logic_check(targetname=stackout,nexn=nexn,zoffcorr=zoffcorr,maskcorr=maskcorr,noiscalc=noiscalc,timecalc=timecalc,lincorr=lincorr,unitcorr=unitcorr,cridcalc=cridcalc,bkgcorr=bkgcorr,doextr=doextr,dowvcal=dowvcal,dowvalgn=dowvalgn,flatcorr=flatcorr,doflcal=doflcal,maskfile=maskfile,noisfile=noisfile,linfile=linfile,bkgfile=bkgfile,extrfile=extrfile,wvfile=wvfile,flatfile=flatfile,calfile=calfile,zoffchk=yes,maskchk=yes,noischk=yes,timechk=yes,linchk=yes,unitchk=yes,cridchk=yes)

##output from _logic_check is struct containing final lgc parameter values
logicvals=_logic_check.outlogic
junk=fscan(logicvals,zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc,extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc)

##create final datred logical value
datred=(zofflgc) || (masklgc) || (noislgc) || (timelgc) || (linlgc) || (unitlgc) || (cridlgc) || (masklgc) || (noislgc) || (linlgc)

###############################################################################
###################create output file##########################################
##This goes into current directory
##filename is name_run_ima.inc.fits where inc is a number which
##increments with each run of doschmidt on the same raw data from
##the same directory

inc=1
while(access(imaout)){
  imaout=imaoutroot//"."//inc//".fits"
  inc+=1
}
print("DOCIRPASS: Creating ",imaout)
#copy(stackout,imaout,verb-)
fxcopy(stackout,imaout,groups="",new_file+)
imaph=imaout//"[0]"

##################run data reduction tasks#####################################
##run lincorr if lincorr=perform
if(linlgc){
  print("Running lincorr")
  lincorr(imaout)
  hedit(imaph,"LINDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"LINDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run zerosub if zofflgc
if(zofflgc){
  print("Running zerosub")
  zsub(imaout)
##change keyword zoffdone to performed
  hedit(imaph,"ZOFFDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"ZOFFDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run badmask if masklgc
if(masklgc){
  print("Running badmask")
  print("Sorry badmask isn't written yet")
  hedit(imaph,"MASKDONE","OMITTED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"MASKDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run mkerr if noislgc
if(noislgc){
  print("Running mkerr")
  mkerr(imaout,readnoise,gain)
  hedit(imaph,"NOISDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"NOISDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run mktime if timelgc
if(timelgc){
  print("Running mktime")
  print("Sorry mktime isn't written yet")
  hedit(imaph,"TIMEDONE","OMITTED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"TIMEDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run ctrate is unitlgc
if(unitlgc){
  print("Running ctrate")
  print("Sorry ctrate isn't written yet")
  hedit(imaph,"UNITDONE","OMITTED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"UNITDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run cosmic if cridlgc
if(cridlgc){
  print("Running cosmic")
#  cosmic(imaout)
 coscirp(imaout) 
 hedit(imaph,"CRIDDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"CRIDDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##change CALSTAGE to be docirpass
hedit(imaph,"CALSTAGE","docirpass",add-,delete-,verify-,show-,update+)

#########################end of data reduction#################################

#########################show results##########################################
##if you've done any imaibration then display the final science image
##from the _ima file

#if(datred){
if(inter){
  display(imaout//"["//sciname//",1]",1)
}
#}

print("\n***** Reduced file is ",imaout, " *****\n")

###############################################################################

#########################tidy up###############################################
##increment the run no at the end so it's set for the next run
#run_no=frunno+1
###############################################################################

end
