
# Script to define the Cirpass Package which contains all scripts for 
# reducing data for Cirpass. 

# Load necessary packages

	artdata
	onedspec
	images.immatch

# Define cirpass variables

set cirpraw = /data1/cirpass/
set cirpred = /data2/datared/

package cirpass 

## Define scripts

### Iraf scripts
##Pipeline tasks
	task docirpass  = cirpass$docirpass.cl
#	task docirpass2 = cirpass$docirpass2.cl #runs cosmic2 and produces ima2
	task dotarget   = cirpass$dotarget.cl
	task doajd      = cirpass$doajd.cl
	task dodisplay  = cirpass$dodisplay.cl
	task doflat	= cirpass$doflat.cl

##Component tasks
	task stack_read = cirpass$stack_read.cl
	task stack_average = cirpass$stack_average.cl
	task mefarith   = cirpass$mefarith.cl
        task cirphedit  = cirpass$cirphedit.cl
	task cirphprint = cirpass$cirphprint.cl
	task secstat    = cirpass$secstat.cl
	task secgain    = cirpass$secgain.cl
	task _logic_check = cirpass$_logic_check.cl
	hide _logic_check
	task $mktoday   = cirpass$mktoday.cl
	task $mk2ktoday = cirpass$mk2ktoday.cl
	task gainmeas   = cirpass$gainmeas.cl
	task get_gain   = cirpass$get_gain.cl
	task gain       = cirpass$gain.cl
	task ldisplay   = /home/cirpass/iraf/ldisplay/ldisplay.e
	task quickdisp  = cirpass$quickdisp.cl
	task copy_imsets = cirpass$copy_imsets.cl
	task extract1    = cirpass$extract1.cl
	task doread      = cirpass$doread.cl
	task idisplay    = cirpass$idisplay.cl
	task sub         = cirpass$sub.cl
#	task findpos     = cirpass$findpos.cl
#	task findpos_auto= cirpass$findpos_auto.cl
	task locatepeaks = cirpass$locatepeaks.cl
	task locatepeaks_sep = cirpass$locatepeaks_sep.cl
	task mefdisplay  = cirpass$mefdisplay.cl
	task gausspeaks = cirpass$gausspeaks.cl		
	task fibcal     = cirpass$fibcal.cl
	task centroidpeaks=cirpass$centroidpeaks.cl
	task usm	= cirpass$usm.cl
	task mefmedian   = cirpass$mefmedian.cl	
	task ohmask	= cirpass$ohmask.cl
	task hartmann	= cirpass$hartmann.cl
	task ifuoffset	= cirpass$ifuoffset.cl
	task autofocus 	= cirpass$autofocus.cl
	task makewvcal	= cirpass$makewvcal.cl
	task wvcal	= cirpass$wvcal.cl
	task szap	= cirpass$szap.cl
	task mosaic_ifu	= cirpass$mosaic_ifu.cl
	task beam_switch= cirpass$beam_switch.cl

# C programs 
	task $zsub	= "$foreign"
	task $mkerr     = "$foreign"
	task $lincorr   = "$foreign"
        task $cosmic    = "$foreign"
	task $cosmic2   = "$foreign"
	task $plot      = "$foreign"
	task $lsqfit    = "$foreign"
	task $bit_check = "$foreign"
	task $addfibreinfo="$foreign"
	task $optextract = "$foreign"
	task $optextract_float = "$foreign"
	task $specmark	= "$foreign"
	task $cirparith = "$foreign"
	task $makemef	= "$foreign"
	task $makemef2	= "$foreign"
	hide makemef2

# External programs

	task $convert	= "$foreign"
	hide convert
	task $montage	= "$foreign"
	hide montage

##Package parameters
        task cirpasspars = cirpass$cirpasspars.par 

# Sub packages
	set utils          = cirpass$Utils/
	task $utils.pkg    =utils$utils.cl

# Shell scripts
	

clbye()

