# overwrite_table.cl
#
# iraf script to overwrite a table in a CIRPASS MEF file
# using a text file as the basis for the new table
# 
# text file format is first line, column names, all remaining
# lines the data
#
# A. J. Dean 10th Mar, 2003

procedure overwrite_table(meffile, tabletxtfile, fixheader)

string meffile {prompt="MEF file to overwrite table"}
string tabletxtfile {prompt="Text file containing table information"}
bool   fixheader {yes, prompt="Add dummy IFU header keywords"}
struct *in {mode="h"}

begin

string p_meffile, p_tabletxtfile
string junk
int answer, i, len, nextend
bool p_fixheader, exist

##load required packages
tables.motd=no
tables
ttools
fitsutil


p_meffile=meffile
p_tabletxtfile=tabletxtfile
p_fixheader=fixheader

# check for .fits on the end of input image file

        len=strlen(p_meffile)
        if(substr(p_meffile,len-4,len)!=".fits") {
                p_meffile=p_meffile//".fits"
        }


exist=access(p_tabletxtfile)
if(!exist){
		print("Reference position file ",p_tabletxtfile," does not exist!")
		bye		
		
}


# find out how many lines in the text file

in=p_tabletxtfile
# skip the 1 line of text at the top of the file

answer=fscanf(in,"%s",junk)

i=0
while(fscan(in,junk)!=EOF){
	  i+=1
}

#print(i, "lines in file")

# fxdelete does not change the nextend keyword

nextend=0 # to keep scan happy
hselect(p_meffile//"[0]","nextend",yes) | scan(nextend)

fxdelete(p_meffile,"1",verb-)
nextend-=1
hedit(p_meffile//"[0]", fields="NEXTEND", value=nextend,
      add-, ver-, update+, show-)
addtable(p_meffile,p_tabletxtfile,i)

if(p_fixheader){
	thedit(p_meffile, keywords="YOVERX",value=-999,show-)
	thedit(p_meffile, keywords="MAXDIST",value=-999,show-)
}

end

