/* unfitcode.c  program to remove the pixel shift introduced by PixCel,
** whereby the first pixels in each quadrant of
** the image can be pushed along x number of pixels in, 
** with some pixels falling off the end.
**
** A. J. Dean.  21st June, 2000
**
*/

#include <stdio.h>
#include "unfit_code.h"

extern int unfit(float* data, int offset)
{
	 
  float temp[DETECTOR_SIZE]={0}; 
  float* p_temp;
  
  int i=0;
  int j=0;
  
  p_temp=temp;
  
  
  for( i=offset; i<DETECTOR_X; i++ ){
    
    for( j=0; j<DETECTOR_Y; j++ ){ 
      
      *(p_temp+i-offset+j*DETECTOR_X) = *(data+i+j*DETECTOR_X);
    
      
    }
       
  }
  
  
  for( i=0; i<offset; i++ ){

    for( j=1; j<DETECTOR_Y; j++ ){

      *(p_temp+(DETECTOR_X/2)-offset+i+(j-1)*DETECTOR_X)=*(data+i+j*DETECTOR_X);

    }

  }

  
      
  for( i=(DETECTOR_X/2); i<(DETECTOR_X/2)+offset; i++ ){

    for( j=1; j<DETECTOR_Y; j++ ){

      *(p_temp+i+(DETECTOR_X/2)-offset+DETECTOR_X*(j-1))=*(data+i+j*DETECTOR_X);

    }

  }
    
  /* Copy the temp array over to the input image */
  
  for( i=0; i<DETECTOR_SIZE; i++ ){
    
    *(data+i)=*(p_temp+i);
  
  }
  
  /* successful return */
  return 0;
}





