/* lincorr.c
** Will eventually provide linearity corrections for all pixels
** in a Cirpass ME-FITS data cube
**
** currently just detects saturated pixels
**
** A J Dean 16th Aug, 2000.
**
*/

#include <stdlib.h>
#include <stdio.h>
#include "cirpass.h"
#include "fitswrap.h"

int main(int argc, char* argv[])
{

  float* scidata=NULL;            /* For the science data */
  short* dqdata=NULL;             /* For the dq arrays */
  float thresh=SAT_THRESH;        /* Saturation Threshold */
  long nx=0;                      /* X image dimension */
  long ny=0;                      /* Y image dimension */
  int nextend=0;                  /* Number of extensions in image */
  int next=0;                     /* Number of typed extensions in image */
  int i=0;                        /* Loop variables */
  int j=0;
  int k=0;


  /* check for appropriate input */

 if (argc < 2) {
    fprintf(stderr, 
	    "Usage: %s ME-FITS file\n", 
	    argv[0]);
    exit(1);
 }

 printf("lincorr: Flagging pixels as saturated if counts >=  %f\n",thresh);

 /* read the data in */

 /* nx, ny and nextend will be the same for both */

 scidata=read_ME_FITS(argv[1], "SCI", &nx, &ny, &nextend);

 dqdata=read_ME_FITS_short(argv[1], "DQ", &nx, &ny, &nextend);


 next=nextend / NIMSET;

 /* Loop over pixel values and check if they are above the saturation
  * threshold, if so flag them in the dq array
  */

 for (k=0; k<next; k++){

   for (j=0; j<ny; j++){

     for (i=0; i<nx; i++){

       if (  *(scidata+i+j*nx+k*nx*ny) >= thresh )
	 
	 *(dqdata+i+j*nx+k*nx*ny) |= SATURATED;
	
     }

   }

 }

 /* write out the new data quality data */

 if ( write_ME_FITS_type_short(argv[1], "DQ", dqdata, &nx, &ny, next) ){

   printf("lincorr: failed to write out the dq data\n");
   exit(1);

 }

 free(scidata);
 free(dqdata);

 /* successful return */

 return 0;

}



