#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include "matrix_solver.h"
#include "extract.h"
#include "fitswrap.h"

/*this is the next version after prog1_v3 but reorganised to use */
/*library files etc and also to read in and write out FITS files */

int main ()
{
  int numpk, numval;
  double dd[1];
  int indx[499];
  double peakpos[499];
  double fibpars[499*7]={0};
  double pixval[2048];
  double pixvar[2048];
  double outdata[2048*499]={0};
  double *data[2048];
  double *phi[499];
  double *A[499];
  double *AA[499];
  double *al[499];
  double *peakarr[2048];
  double b[499];
  double c[499];
  double d[499];
  double r[499];
  double u[499];
  double outvar[499];
  char filename[255], infile[255], errfile[255], outfile[255];
  int i, j, k, type, polyorder, nval;
  long naxes[2]={2048,499}; 

  for(i=0;i<499;i++){
    phi[i]=(double*)malloc(2048*sizeof(double));
    A[i]=(double*)malloc(5*sizeof(double));
    AA[i]=(double*)malloc(5*sizeof(double));
    al[i]=(double*)malloc(2*sizeof(double));
  }
  for(i=0;i<2048;i++){
    data[i]=(double*)malloc(2048*sizeof(double));
    peakarr[i]=(double*)malloc(499*sizeof(double));
  }

  /*read FITS file containing spectra to be extracted */
  printf("input FITS filename containing spectra to be extracted\n");
  scanf("%s",infile);

  /*read error values from filename input by user */
  /*CHANGE to read from error array */
  
  /*  printf("input filename containing (2048) variance values\n");
      scanf("%s",filename);*/
  sprintf(errfile,"uni_err.list");
  numval = getval1(errfile, pixvar, 2048);

  /*read output filename input by user*/
  printf("input output FITS filename\n");
  scanf("%s",outfile);
  /*  sprintf(outfile,"out_testextract.fits");*/

  /*read coordinates of peaks, value of fwhm and curvature pars from file */
  /*CHANGE to be from table header*/
  sprintf(filename,"fibpars_all.list");
  numpk = getval2(filename, fibpars);
  printf("%s %d\n","numpk",numpk);
  /*use order of polynomial from fibpars to work out how many values per 
    fibre, and hence total number of fibres*/
  polyorder=*(fibpars+2);
  printf("polyorder %d\n",polyorder);

  /*number of values per fibre = nval*/
  nval=4+polyorder;
  numpk=numpk/nval;
  printf("numpk %d",numpk);
 
  /*work out big array containing peakpos for each column.
    put the answers along the rows of the array to make it quicker to access*/
  for(i=0;i<2048;i++){
    for(j=0;j<499;j++){
      peakarr[i][j]=*(fibpars+3+j*nval)*i*i + *(fibpars+4+j*nval)*i + *(fibpars+5+j*nval);
    }
  } 
  /*  for(i=0;i<numpk;i++){
      printf("i %d peakpos %g\n",i,peakpos[i]);
      }*/
  
  /*get type of profile (ie extending over 1 or 2 adjacent spectra) */
  type=gettype();
  printf("type %d\n",type);
  if(type==3){
    printf("Warning: this program assumes each spectrum only overlaps the four closest neighbouring spectra. With these values of pitch and fwhm this means that < 5sigma of the profile is integrated over, which will lead to errors in the sum\n");
  }

  /*read SCI,1 data from FITS file into array data.
  data is a 2D array which contains the data
  wavelength pixel changing along x and the spatial pixel changing along y */
  printf("reading %s \n",infile);
  readdata(infile, data);
  printf("after readdata\n");

  for(i=0;i<2048;i++){
    /*initialize arrays*/
    for(j=0;j<499;j++){
      r[j]=0;
      u[j]=0;
      b[j]=0;
      c[j]=0;
      d[j]=0;
      peakpos[j]=peakarr[i][j];
      for(k=0;k<2048;k++){
	phi[j][k]=0;
      }
      for(k=0;k<5;k++){
	  A[j][k]=0;
      }
    }

    /*printf("before getphi\n");*/
    /*    printf("numpk %d numval %d type %d\n",numpk,numval,type);*/
    getphi(peakpos, numpk, numval, type, phi);
  
  /*  printf("before getdiag\n");*/
    getdiag(phi,pixvar,b,c,d,A,numpk,numval,type);
  /*   printf("after getdiag\n");*/



  /*feed data a column at a time into routines to find value of each spectrum
  pixval is the vector that contains a column at a time*/
    for(j=0;j<2048;j++){
      pixval[j]=data[j][i];
    }    

    /*   printf("extracting spectra\n");*/

    /*    printf("solving for column %d\n",i);*/
  
    getr(pixval,pixvar,phi,numpk,numval,r);

    /*get output variance */
    getoutvar(pixvar,phi,numpk,numval,outvar);

    if(type==1){
      tridiag(b,c,d,r,u,numpk);
    }
    else{
      bandec(A,numpk,2,2,al,indx,dd);
      banbks(A,numpk,2,2,al,indx,r);
    }
    
    /*printf("writing output matrix for column %d\n",i);*/
    for(j=0;j<499;j++){
      if(j<numpk){
	if(type==1){
	  outdata[j*2048+i]=u[j];
	}
	else{
	  outdata[j*2048+i]=r[j];
	}
	/*	printf("i %d j %d outdata %g\n",i,j,outdata[j*2048+i]);*/
      }
      else{
	outdata[j*2048+i]=0.0;
      }	    
    }
  }
  
  /*write out data to FITS file*/
  printf("writing output FITS file %s \n",outfile);
  writefits_double_basic(outfile,naxes,outdata);

  for(i=0;i<499;i++){
    free(phi[i]);
    free(A[i]);
    free(al[i]);
  }
  for(i=0;i<2048;i++){
    free(data[i]);
  }
      
  return 0;
}
