#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>
#include "fitswrap.h"
#include "extract.h"


#define USE_OLDPHI 0

/*subroutines used in optextract routine*/

/*NBIN 10000 for reasonable speed in getphi but 100000 more accurate*/
/*#define NBIN 100000*/
#define NBIN 10000
#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

/*define M_E and M_PI here for now, but don't understand why it doesn't pick thn up from the math library. in prog1_v3.c didn't have to define these variables*/
#define M_PI 3.1415927
#define M_E 2.7182818

/* Global variables */
double sigma=1.5/2.354; /*fwhm/2.354*/
double pitch=2.034;

int gettype()
{
  double scale;
  int type=0;

  scale=pitch/sigma;
  /*printf("pitch of %g = %g * sigma of %g\n",pitch,scale,sigma);*/
  /*for(i=0;i<numpk;i++) printf("%s %d %s %g\n","i",i,"peakpos",peakpos[i]);
    3 possibilities - 5sigma <= pitch, 2*pitch >= 5sigma > pitch, 2pitch < 5sigma */
  if(scale >= 5) type=1;
  if((scale < 5) && (scale >= 2.5)) type=2;
  if(scale < 2.5) type =3;
  
  /*  printf("scale %g type %d\n",scale,type);*/

  return type;
}

int readdata(char *filename, double **data)
{

  long naxes[]={2048,2048};
  double *temp;
  int i,j;

  printf("in readdata\n");
  printf("reading %s into array temp\n",filename);
  temp=readfits_double_extver(filename, "SCI", 1, naxes, naxes+1);
  
  printf("making data array from temp array\n");
  for(i=0;i<2048;i++){
    for(j=0;j<2048;j++){  
      data[i][j]=temp[j+i*2048];
      /*if(i==700){
	printf("i %d j %d temp %g data %g\n",i,j,temp[j+i*2048],data[i][j]);
	}*/
    }
  }
  return 0;

}

int getgauss(double *gaussval, double _step)
{
  double *gaussval_ptr, term1, term2, term3, pos;

  pos=-5*sigma;
  for(gaussval_ptr=&gaussval[0];gaussval_ptr<&gaussval[NBIN];gaussval_ptr++){
    term1 = 1.0 / (sqrt(2.0*M_PI) * sigma);
    term2 = (0 - pos)/ sigma;
    term3 = -0.5 * pow(term2, 2);
    
    *gaussval_ptr=term1 * pow(M_E, term3)*_step;
    pos+=_step;
  }
  return 0;
}

#if (USE_OLDPHI==1)

double gaussint(double *gaussval, double _ilow, double _ihi, double _peakpos, double _step)
{

  double tot, fivsig, nlowbin, nhibin;
  int i;

  tot=0.0;
  fivsig=5*sigma;
  
  _ilow=_ilow-_peakpos;
  _ihi=_ihi-_peakpos;

  nlowbin=floor(((_ilow+fivsig)/_step)+0.5);
  nhibin=floor(((_ihi+fivsig)/_step)+0.5);

  for(i=nlowbin;i<nhibin;i++)
    tot+=gaussval[i]*_step;
  
  return tot;
}

#else

#define gaussint(_gaussval, _ilow, _ihi, _peakpos, _step) \
  _ilow=_ilow-_peakpos; \
  _ihi=_ihi-_peakpos; \
  nlowbin=floor(((_ilow+5*sigma)/_step)+0.5); \
  nhibin=floor(((_ihi+5*sigma)/_step)+0.5); \
  for(k=nlowbin;k<nhibin;k++) \
    	phi[j][i]+=_gaussval[k]; 

#endif


int getval1 (char *filename, double *val, int ppsize)
{
  /*read in doubles from file filename */

  int i, numval;
  FILE *infile;

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }

  i=0;
  do {
    fscanf(infile,"%lf",val+i);
    i++;
  } while(!feof(infile)&&i<=ppsize);
  numval=i-1;

  return numval;
}

int getval2 (char *filename, double *fibpars)
{
  /*read in any number of doubles from file
  probably overkill to have this and getval1 but need
  old optextract routine to still work so can't change getval1*/

  int i, numval;
  FILE *infile;
  
  printf("in getval2 in extract\n");

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }

  i=0;

  do {
    fscanf(infile,"%lf",fibpars+i);
    /*    printf("i %d fibpars %g\n",i,*(fibpars+i));*/
    i++;
  } while(!feof(infile));
  numval=i-1;

  return numval;
}

#if (USE_OLDPHI==1)

int getphi ( double *peakpos, int numpk, int numval, int type, double **phi)
{

  double pmin, pmax, ilow, ihi, step;
  double *gaussval;
  int i,j,pixnum;

  gaussval=(double*)malloc(NBIN*sizeof(double));

  /*printf("in getphi\n");
    printf("sigma %g NBIN %d\n",sigma,NBIN);*/

  step=(10*sigma)/NBIN;
  /*  printf("step is %g\n",step);*/

  /*populate gaussian array values*/
  /*printf("before getgauss\n");*/
  getgauss(gaussval,step);

  for(j=0;j<numpk;j++){
    if((type==1)||(type==2)){
      pmin=peakpos[j]-5*sigma;
      pmax=peakpos[j]+5*sigma;
      /*printf("type = %d j %d pmin %g pmax %g peak %g\n",type,j,pmin,pmax,peakpos[j]);*/
    }
    else{
      if((j==0)||(j==1)){
	pmin=peakpos[j]-2*pitch;
	/*printf("%s %d %s %g\n","j",j,"peakpos",peakpos[j]);*/
      }
      else{
	pmin=peakpos[j-2];
      }
      if((j==numpk-1)||(j==numpk-2)){
	pmax=peakpos[j]+2*pitch;
      }
      else{
	pmax=peakpos[j+2];
      }

    }

    /*    printf("before numval loop\n");*/
    for(i=0;i<numval;i++){
      /*use i+1 here because these are pixel centres and first pixel is centred at 1*/
      pixnum=i+1;


      if((pixnum<abs(pmin+0.5))||(pixnum>abs(pmax+0.5))){
	phi[j][i]=0.0;
      }
      else{
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);


	phi[j][i]=gaussint(gaussval,ilow,ihi,peakpos[j],step);


      }
    }
  }

  return 0;
}

#else

int getphi ( double *peakpos, int numpk, int numval, int type, double **phi)
{

  double pmin, pmax, ilow, ihi, step;
  double *gaussval;
  float pixnum;
  int i,j;

  int k, nlowbin, nhibin;

  gaussval=(double*)malloc(NBIN*sizeof(double));
  for(i=0;i<NBIN;i++){
    gaussval[i]=0;
  }

  /*printf("in getphi\n");
    printf("sigma %g NBIN %d\n",sigma,NBIN);*/

  step=(10*sigma)/NBIN;
  /*printf("step is %g\n",step);*/

  /*populate gaussian array values*/
  /*printf("before getgauss\n");*/
  getgauss(gaussval,step);

  if((type==1)||(type==2)){
    for(j=0;j<numpk;j++){
      pmin=peakpos[j]-5*sigma;
      pmax=peakpos[j]+5*sigma;

      for(i=0;i<abs(pmin+0.5)-1;i++){
	/*	pixnum=i+1;*/
	/*use i+1 here because these are pixel centres and first pixel is centred at 1*/
	phi[j][i]=0.0;
      }
      for(i=abs(pmin+0.5)-1;i<abs(pmax+0.5);i++){
	pixnum=i+1;
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);

	phi[j][i]=0.0;
	gaussint(gaussval,ilow,ihi,peakpos[j],step);
      }
      for(i=abs(pmax+0.5);i<numval;i++){
	phi[j][i]=0.0;
      }
    }
  }
  else{
    for(j=0;j<numpk;j++){
      if(j<2){
	pmin=peakpos[j]-2*pitch;
	/*printf("%s %d %s %g\n","j",j,"peakpos",peakpos[j]);*/
      }
      else{
	pmin=peakpos[j-2];
      }
      if(j>numpk-3){
	pmax=peakpos[j]+2*pitch;
      }
      else{
	pmax=peakpos[j+2];
      }
      for(i=0;i<abs(pmin+0.5)-1;i++){
	/*	pixnum=i+1;*/
	/*use i+1 here because these are pixel centres and first pixel is centred at 1*/
	phi[j][i]=0.0;
      }
      for(i=abs(pmin+0.5)-1;i<abs(pmax+0.5);i++){
	pixnum=i+1;
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);

	phi[j][i]=0.0;
	gaussint(gaussval,ilow,ihi,peakpos[j],step);
      }
      for(i=abs(pmax+0.5);i<numval;i++){
	phi[j][i]=0.0;
      }
    }
  }

  return 0;
}

#endif


int getdiag(double **phi, double *pixvar, double *b, double *c, double *d, double **A, int numpk, int numval, int type)
{
  int i,k;
  double temp;
  /*get diagonals of tridiagonal and 5-band diagonal matrix*/
  
  /*  printf("in getdiag numpk %d numval %d\n",numpk,numval);*/
  for(k=0;k<numpk;k++){
    if((type!=1)&&(k>1)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k-2][i]>0)){
	  temp=phi[k][i]*phi[k-2][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][0]+=temp;
      }
    }
    if(k>0){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k-1][i]>0)){
	  temp=phi[k][i]*phi[k-1][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][1]+=temp;
      }
    }
  
    for(i=0;i<numval;i++){
      if(phi[k][i]>0){
	temp=phi[k][i]*phi[k][i]/pixvar[i];
      }
      else{
	temp=0;
      }
      A[k][2]+=temp;
    }
    if(k<(numpk-1)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k+1][i]>0)){
	  temp=phi[k][i]*phi[k+1][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][3]+=temp;

      }
    }
    if((type!=1)&&(k<numpk-2)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k+2][i]>0)){
	  temp=phi[k][i]*phi[k+2][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][4]+=temp;
      }
    }

  }
  
  for(i=0;i<499;i++){
    b[i]=A[i][1];
    c[i]=A[i][2];
    d[i]=A[i][3];
  }

return 0;
}

int getr(double *pixval, double *pixvar, double **phi, double numpk, double numval, double *r)
{
  int i,j;

  for(j=0;j<numpk;j++){
    for(i=0;i<numval;i++){
      if(phi[j][i]!=0){
	r[j]+=pixval[i]*phi[j][i]/pixvar[i];
      }
    }
  }
  
  return 0;
}

int getoutvar(double *pixvar, double **phi, double numpk, double numval, double *outvar)
{
  int i,j;

  /*output variance for each profile is the value of the variance in a pixel 
    multiplied by the value of the profile in that pixel. this seems like
    a fairly sensible way of doing things ? */
  for(j=0;j<numpk;j++){
    for(i=0;i<numval;i++){
      if(phi[j][i]!=0){
	outvar[j]+=pixvar[i]*phi[j][i];
      }
    }
  }

  return 0;
}

