# IRAF script -- coscirp.cl
#
#	Andrew Bunker, Institute of Astronomy, Cambridge
#	Tue Aug 20 11:47:35 BST 2002
#
#   function: to reject cosmics in CIRPASS using multiple non-destructive reads
#

procedure coscirp(inlist)

string  inlist          {prompt="Input ima image?"}
string  outimage        {"cr",prompt="Prefix for output image?"}
string  rej		{"crrej",prompt="imcomb rejection (crrej, ccdclip)?"}
real    snoise		{0.2,prompt="imcomb sensitivity noise?"}
bool	docomb	   {yes, prompt="Combine the images?"}
bool    doscale    {yes, prompt="Scale to total exp time?"}

struct  *inimglist
struct  *incomblist

begin
        string  inl, inimages, incomb
	int loop, len
	

# Expand file lists into temporary files.

        inimages = mktemp("tmp$coscirp")
        sections (inlist,option="fullname",>inimages)
        inimglist = inimages

# Loop through input files:

        while (fscan(inimglist,inl) != EOF) {
	
	# check for .fits on the end ** AJD change **
        len=strlen(inl)
        if(substr(inl,len-4,len)==".fits") {
                inl=substr(inl,1,len-5)
        }

        incomb = mktemp("tmp$coscirpls")


	imgets(inl//"[0]","NLOOPS")
	loop=int(imgets.value)

	for(i=1;i<=loop;i+=1){
	  imarith(inl//"[SCI,"//i//"]","-",inl//"[SCI,"//i+1//"]","tmp_"//inl//i)
        sections ("tmp_"//inl//i,option="fullname",>>incomb)

	  }

	  incomblist=incomb

	if (docomb == 1) {
	print("combining loops and rejecting cosmics")
	print("### REMEMBER to epar imcombine ###")
	print("to set lsigma,hsigma,rdnoise,gain")

	imcombine("@"//incomb,"tmp_"//outimage//inl,rejmask="rej_"//outimage//inl,reject=rej,snoise=snoise)
	if (doscale == 1) {
	   imarith("tmp_"//outimage//inl,"*",loop,"tmp_"//outimage//inl)
	   }
	
# Overwrite input file and make a mef with only 4 extensions ** AJD change **
	makemef(inl//".fits","tmp_"//outimage//inl//".fits",outimage//".fits")


#	copy(inl//".fits",outimage//inl//".fits")
#	imcopy("tmp_"//outimage//inl//"[*,*]",outimage//inl//"[sci,1][*,*]",
#		ver-)
		
	delete(inl//".fits")
	copy(outimage//".fits", inl//".fits",verbose+)
	delete(outimage//".fits")

	# Clean up
        imdel("tmp_"//inl//"*.fits",ver-)
        imdel("tmp_"//outimage//inl,ver-)

	}
	}
	del("tmp$coscirp*",ver-)

end
