/* median.c Finds the median value of a data set 
**
** A. J. Dean, 18th July, 2001.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "mathutils.h"

typedef struct bin{
  
  float dataval;
  float min;
  float max;
  int count;
  struct bin* next;
  struct bin* previous;

}bin;

static bin* newbin(void);

extern float median(float* data, int ndata)
{

  float min=0;
  float max=0;
  float step=0;
  int nbins=0;
  int midpt=0;
  float f_midpt=0;
  int sum=0;

  float midval=0;

  int isodd=0;
  int i=0;
  int j=0;

  bin* currentbin=NULL;
  bin* insertbin=NULL;
  bin* nextbin=NULL;
  bin* first=NULL;

  
  if(ndata<100){

    /* Order the data without binning */
    nbins=ndata;
    first = currentbin = newbin();
    currentbin->dataval=*(data);
    currentbin->next=NULL;
    currentbin->previous=NULL;
    
    for(i=1; i<nbins; i++){

      currentbin=first;
      
      /* Move to where we want to insert bin */
      while( (*(data+i) >= currentbin->dataval ) && (currentbin->next!=NULL) ){ 
	
	currentbin=currentbin->next;

      }
   
      /* We may need to go before or after current bin, depending on whether
	 we came here due to the data or the null test */
      if( *(data+i) >= currentbin->dataval ){ /* Must be on the end */
	
	/*Insert the newbin after */  
	insertbin = newbin();
	insertbin->dataval=*(data+i);
	insertbin->previous=currentbin;
	insertbin->next=currentbin->next;
	/* Definitely on end so don't need to worry about the next bins 
	   pointer back */
	currentbin->next=insertbin;

      } else { 
	
	/* Insert the newbin before */
	insertbin = newbin();
	insertbin->dataval=*(data+i);
	insertbin->previous=currentbin->previous;
	insertbin->next=currentbin;
	if(currentbin->previous!=NULL){
	  
	  (currentbin->previous)->next=insertbin;
	  
	} else {
	  
	  first=insertbin;
	  
	}
	
	currentbin->previous=insertbin;
      
      }
      
    }
    
    midpt=nbins/2; /* Rounds down */
    isodd=(int)(nbins-midpt*2);
    currentbin=first;
    for(i=2; i<=midpt+1; i++){ /* Midpoint is at midpt+1 if odd */
      
      currentbin=currentbin->next;
      
    }
        
    if(isodd){
      
      midval=currentbin->dataval;
      
    } else {
      
      midval=(currentbin->dataval+currentbin->previous->dataval)/2;
      
    }
    
  } else { /* lots of data so bin it first ! */

    nbins=1000; /* Should probably make this depend more on ndata */

    /* Find the min and max in the data set */
    minmax(data, ndata, &min, &max);
    step = (max-min)/(float)nbins;
    /*printf("Data: min is %f, max is %f, step is %f\n",min,max,step);*/
    
    first = currentbin = newbin();
    currentbin->min=min;
    currentbin->max=min+step;
    currentbin->count=0;
    /*printf("First bin: min is %f, max is %f\n",currentbin->min,currentbin->max);*/
    for(i=1; i<nbins; i++){

      currentbin->next=newbin(); /* Make bin number i, there is a bin 0! */
      currentbin->next->min=currentbin->min+step;
      currentbin->next->max=currentbin->max+step;
      currentbin->next->count=0;
      /*printf("min is %f, max is %f\n",currentbin->next->min,currentbin->next->max);*/
      currentbin = currentbin->next;
      
    }
    
    currentbin->next=NULL;

    /* First bin has to catch the minimum value of the data */
    currentbin=first;
    currentbin->min*=0.99;
    
    /* Put the data into the bins */ 
    for(i=0; i<ndata; i++){
      currentbin=first;
      for(j=0; j<nbins; j++){
	
	if( (*(data+i) > currentbin->min) && (*(data+i) <= currentbin->max)){
	  currentbin->count++;
	  break;
	} else {
	  
	  currentbin=currentbin->next;
	  
	}
	
      }
      
    }
 
    /* Print breakdown of bins for diagnosis */
    /*currentbin=first;
    for(i=0; i<nbins; i++){
      printf("bin %i min is %f, max is %f, count is %i\n", i, currentbin->min,currentbin->max, currentbin->count);
      currentbin=currentbin->next;
      }*/
    
    
    /* Find the bin range which has the middle point in it */
    f_midpt=(float)ndata/2.0;

    currentbin=first;
    sum=0;
    for(i=0; i<nbins; i++){
      
      sum+=currentbin->count;
    
      if(sum>=(int)f_midpt){
	
	midval= currentbin->min + (f_midpt - ( (float)sum - (float)currentbin->count ) ) * step / (float)currentbin->count;

	break;
	
      }
      
      currentbin=currentbin->next;
    
    }

    /*printf("median=%f\n",midval);*/
    
  }
  
  /* Free the bins */
  currentbin=first;
  
  for(i=0; i<nbins; i++){
    
    nextbin=currentbin->next;
    free(currentbin);
    currentbin=nextbin;
    
  } 

  return midval;

}


static bin* newbin(void)
{

  bin* anewbin=NULL;
  
  if ( (anewbin=(bin *)malloc(sizeof(bin))) == NULL ){
    
    printf("median: Memory allocation for bins failed!");
    exit(1);
  }

  return anewbin;
    
}




