# if !defined(CIRPASS_)
# define CIRPASS_

# if defined(_cplusplus)
extern "C" {
# endif

/* cirpass.h -- global header file for cirpass data reduction code */

# define FNAMELENGTH 100                /* Maximum length of a filename */

/* Cirpass, instrument specific */

#define         DETECTOR_X     1024
#define         DETECTOR_Y     1024
#define         DETECTOR_SIZE  (DETECTOR_X*DETECTOR_Y)

#define         PIXEL_SHIFT     3       /* PixCel produces offset error */
#define         NOFIBRE         0       /* IFU lens has no fibre */
#define         NOTEXTRACTED    0       /* Spectrum not extracted */
#define         NOTINSLIT      -999     /* IFU fibre not in slit */
#define         CALFIBRE       -999     /* Calibration fibre not in IFU */
#define         MISSEDDET      -999     /* Fibre missed detector */

/* Data reduction specific */

#define         NIMSET          4       /* Number of imsets in extension */
#define         MSNIMSET        2       /* Number of imsets in ms extension */
#define         ZEROREAD        2       /* Read containing the Zeroth read */
#define         SAT_THRESH      15000   /* Saturation threshold */
#define         DISPSIZE        512     /* Output image size of ifudisplay */

/* Data Quality Flag values */

# define	REED_SOL	1	/* Reed-Solomon decoding error */
# define	BAD_LIN		2	/* Poor linearity correction */
# define	BAD_DARK	4	/* Poor dark correction */
# define	BAD_FLAT	8	/* Poor flat field correction */
# define	GROT		16	/* Pixel affected by "grot" */
# define	DEFECTIVE	32	/* Hot or cold pixel */
# define	SATURATED	64	/* Saturated pixel */
# define	MISSING		128	/* Missing data (telemetry dropout) */
# define	BADPIX		256	/* Bad pixel set during calibration */
# define	CR_HIT		512	/* Cosmic Ray hit */
# define	SOURCE		1024	/* Pixel contains source */
# define	ZEROSIG		2048	/* Zero read signal correction */
# define	USER1		4096	/* User flag value 1 */
# define	USER2		8192	/* User flag value 2 */
# define	RESERVED1	16384	/* Reserved flag value 1 */
# define	RESERVED2	32768	/* Reserved flag value 2 */


  /* #define DEADPIX 4 */


  /* #define DEBUG_STACK  */

# if defined(_cplusplus)
}
# endif

# endif /* defined(CIRPASS_) */






