#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>
#include "fitswrap.h"
#include "extract_float.h"

/* 15/12/01 changed to use the fwhm in the extraction parameters file
   instead of the hardwired value.
   removed gettype subroutine
   changed getgauss to find gaussian values at positions given as a function of sigma
   changed gaussint to use the above gaussian values  
*/

/*subroutines used in optextract routine*/
#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

/*define M_E and M_PI here for now, but don't understand why it doesn't pick thn up from the math library. in prog1_v3.c didn't have to define these variables*/
#define M_PI 3.1415927
#define M_E 2.7182818

/*external variables*/
/*extern int IMSIZE;
  extern int NUMFIBRE;*/

int readdata(char *filename, float **data, char *extname, int extnum)
{

  float *temp;
  int i,j;

  /*printf("in readdata\n");*/
  /*printf("reading %s into array temp\n",filename);*/
  temp=readfits_float_extver(filename, extname, extnum);
  
  /*printf("making data array from temp array\n");*/
  for(i=0;i<1024;i++){
    for(j=0;j<1024;j++){  
      data[i][j]=temp[j+i*1024];
      /*if(i==700){
	printf("i %d j %d temp %g data %g\n",i,j,temp[j+i*1024],data[i][j]);
	}*/
    }
  }
  return 0;

}

int getgauss(float *gaussval, float step, int nbin)
{
  float *gaussval_ptr, term1, term2;
  int i;

  i=0;

  for(gaussval_ptr=&gaussval[0];gaussval_ptr<&gaussval[nbin];gaussval_ptr++){
    term1 = step*i - 5;
    term2 = -0.5 * pow(term1,2);

    *gaussval_ptr=pow(M_E, term2);

    /*printf("step %g i %d term1 %g term2 %g\n",step,i,term1,term2);*/
    i++;
  }
  return 0;
}


#define gaussint(_gaussval, _ilow, _ihi, _peakpos, _binw, _sigma,_cons) \
  _ilow=_ilow-_peakpos; \
  _ihi=_ihi-_peakpos; \
  nlowbin=floor(((_ilow+5*_sigma)/_binw)+0.5); \
  nhibin=floor(((_ihi+5*_sigma)/_binw)+0.5); \
/*  printf("in gaussint nlowbin %d nhibin %d\n",nlowbin,nhibin);*/ \
  for(k=nlowbin;k<nhibin;k++){ \
/*printf("_ilow %g _ihi %g nlowbin %d nhibin %d k %d _sigma %g _gaussval %g \n",_ilow,_ihi,nlowbin,nhibin,k,_sigma,_gaussval[k]);*/ \
    phi[j][i]+=_cons*_gaussval[k]*_binw; \
  }
/*printf("at bottom of gaussint phi %g\n",phi[j][i]); */
   /*printf("in gaussint _ilow %g _ihi %g _peakpos %g _step %g _sigma %g nlowbin %d nhibin %d phi %g\n",_ilow, _ihi, _peakpos, _step, _sigma,nlowbin,nhibin,phi[j][i]);*/


int getval1 (char *filename, float *val, int ppsize)
{
  /*read in floats from file filename */

  int i, numval;
  FILE *infile;
  
  /*printf("in getval1 in extract_float\n");*/

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }

  i=0;
  do {
    fscanf(infile,"%g",val+i);
    i++;
  } while(!feof(infile)&&i<=ppsize);
  numval=i-1;

  return numval;
}

int getval2 (char *filename, float *fibpars)
{
  /*read in any number of floats from file
  probably overkill to have this and getval1 but need
  old optextract routine to still work so can't change getval1*/

  int i, numval;
  FILE *infile;
  
  /*printf("in getval2 in extract_float\n");*/

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }


  i=0;


  do {
    fscanf(infile,"%g",fibpars+i);
    i++;
  } while(!feof(infile));
  numval=i-1;

  return numval;
}


int getphi ( float *peakpos, float *fwhm, int numpk, int numval, float **phi, float *gaussval, float step)
{

  float pmin, pmax, ilow, ihi;
  float pixnum, sigma,binw,cons;
  int i,j,k,nlowbin,nhibin;

  for(j=0;j<numpk;j++){
    sigma=fwhm[j]/2.354;
    /*define variables to try and speed up gaussint*/
    binw=step*sigma;
    cons=1/(sqrt(2*M_PI)*sigma);

    /*printf("spectrum %d sigma %g binw %g cons %g\n",j+1,sigma,binw,cons);*/

    /*find pmin and pmax, the min and max values where spectrum j at
      position peakpos[j] and with sigma=sigma has a value > 0.
      we can only calculate the spectra values if they overlap <=2 neighbours on
      each side, so the positions of the peaks two away from the current one are
      the min and max values for pmin and pmax, even if the profile is non-zero
      beyond those points. In this case the extracted values will be incorrect.*/
    pmin=peakpos[j]-5*sigma;
    pmax=peakpos[j]+5*sigma;

    if(pmin<0.5){  /*check if pmin is off bottom of detector*/
      pmin=0.5;
    }
    else if((j>1)&&(pmin<peakpos[j-2])){ /*check if it goes beyond position of*/
      pmin=peakpos[j-2];               /*second neighbour*/
    }
    
    if(pmax>1024.5){
      pmax=1024.5;
    }
    else if((j<numpk-2)&&(pmax>peakpos[j+2])){
      pmax=peakpos[j+2];
    }
    

    /*    printf("j %d pmin %g pmax %g\n",j,pmin,pmax);*/
    /*printf("j %d peakpos[j] %g sigma %g pmin %g pmax %g\n",j,peakpos[j],sigma,pmin,pmax);*/
    
    for(i=abs(pmin+0.5)-1;i<abs(pmax+0.5);i++){
      pixnum=i+1;
      ilow=MAX(pixnum-0.5,pmin);
      ihi=MIN(pixnum+0.5,pmax);


      /*printf("in getphi just before gaussint phi j %d i %d %g\n",j,i,phi[j][i]);*/
      gaussint(gaussval,ilow,ihi,peakpos[j],binw,sigma,cons);
      /*printf("in getphi pixel %d ilow %g ihi %g peakpos %g phi %g\n",i+1,ilow,ihi,peakpos[j],phi[j][i]);*/
      /*      printf("spec %d pixel %d phi[j][i] %g\n",j+1,i+1,phi[j][i]);*/
    }
  }

  return 0;
}


int getdiag(float **phi, float *pixvar, float *b, float *c, float *d, float **A, int numpk, int numval)
{
  int i,k;
  float temp;

  /*get diagonals of tridiagonal and 5-band diagonal matrix*/
  
  /*  printf("in getdiag numpk %d numval %d\n",numpk,numval);*/
  for(k=0;k<numpk;k++){
    if(k>1){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k-2][i]>0)){
	  temp=phi[k][i]*phi[k-2][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][0]+=temp;
      }
    }
    if(k>0){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k-1][i]>0)){
	  temp=phi[k][i]*phi[k-1][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][1]+=temp;
      }
    }
  
    for(i=0;i<numval;i++){
      if(phi[k][i]>0){
	temp=phi[k][i]*phi[k][i]/pixvar[i];
      }
      else{
	temp=0;
      }
      A[k][2]+=temp;
    }
    if(k<(numpk-1)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k+1][i]>0)){
	  temp=phi[k][i]*phi[k+1][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][3]+=temp;

      }
    }
    if(k<numpk-2){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k+2][i]>0)){
	  temp=phi[k][i]*phi[k+2][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][4]+=temp;
      }
    }

  }
  
  for(i=0;i<502;i++){
    b[i]=A[i][1];
    c[i]=A[i][2];
    d[i]=A[i][3];
  }

return 0;
}

int getr(float *pixval, float *pixvar, float **phi, float numpk, float numval, float *r)
{
  int i,j;

  for(j=0;j<numpk;j++){
    for(i=0;i<numval;i++){
      if(phi[j][i]!=0){
	r[j]+=pixval[i]*phi[j][i]/pixvar[i];
      }
    }
  }
  
  return 0;
}

int getoutvar(float *pixvar, float **phi, float numpk, float numval, float *outvar)
{
  int i,j;

  /*output variance for each profile is the value of the variance in a pixel 
    multiplied by the value of the profile in that pixel. this seems like
    a fairly sensible way of doing things ? */
  for(j=0;j<numpk;j++){
    outvar[j]=0;
    for(i=0;i<numval;i++){
      if(phi[j][i]!=0){
	/*this if statement for checking pixvar calc for optimal extraction
	if(j==267)
	printf("j %d i %d pixvar %g phi %g\n",j,i,pixvar[i],phi[j][i]);*/
	outvar[j]+=pixvar[i]*phi[j][i];
      }
    }
  }

  return 0;
}

