
#
# mosaic.cl 
#
# iraf script to combine offset ifu images
#
# A. J. Dean 9th Aug, 2002
#
# Format of offset file is x_offset y_offset
# The offset is the lens coordinates in the new IFU image of a 
# reference object relative to its position in the first IFU image 
# in the list

procedure mosaic(ifuimagefile, offset_file, output_file)

string ifuimagefile {prompt="File list of input ifuimages"}
string offset_file  {prompt="File containing the list of offsets"}
string output_file  {prompt="Output ms file"}
bool   overw        {mode="l", prompt="overwrite output file?"}

struct *in {mode="h"}

begin

string ifuimfile, offsetfile, outfile
string ifuimages[500]
string tempstring, inlist, poslist, tempspec, lenslist, tempms
string ifuconfigfile
#string tempscopy

int x[500], y[500]
int tempx, tempy, templens, tempap

int lens[5000], gridx[5000], gridy[5000], apnum[5000]
int mingridx, maxgridx
int mingridy, maxgridy

int maxoffx, minoffx
int maxoffy, minoffy

int num, numlens, lenscount

int newgridminx, newgridmaxx
int newgridminy, newgridmaxy

int lensx, lensy, spectrum
int specdim, len
int i, j, k, h, count

int nextend

bool gotalens, exist, over

#***** Load necessary packages
if (!defpac ("stsdas")) {
	stsdas(motd-)
}

tables
fitsutil
utils


#***** Stuff that's used a lot
cache("scombine","imcopy")

#***** So you don't forget!
print("")
print("******** epar scombine to tune it as desired *********")
print("***** dispaxis for scopy needs to be correct too *****")
print("")

#***** Query parameters
ifuimfile=ifuimagefile
offsetfile=offset_file
outfile=output_file

# check for .fits on the end of filenames
len=strlen(outfile)
if(substr(outfile,len-4,len)!=".fits") {
	outfile=outfile//".fits"
}

# check for existence of files

exist=access(ifuimfile)
if(!exist){
                print("Image list file ", ifuimfile," does not exist!")
                bye

}

exist=access(offsetfile)
if(!exist){
                print("Offset list file ", offsetfile," does not exist!")
                bye

}

# check if output file already exists
exist=access(outfile)
if(exist){
                print("!!!!! output file ", outfile," exists !!!!!")
                over=overw
                if(over){
                        delete(outfile)
                } else {
                        print("You should probably pick a different output file name!")
                        bye
                }
}

#***** Read in the ifu image file
in=ifuimfile
i=1
while(fscan(in,tempstring)!=EOF){
	# check for .fits on the end of filenames
	len=strlen(tempstring)
	if(substr(tempstring,len-4,len)!=".fits") {
	tempstring=tempstring//".fits"
	}
	ifuimages[i]=tempstring
#	print("Got image",tempstring)
	i+=1
	if(i>500){
		error(11,"You have more than 500 IFU images!\nArray for IFU images has run out of room!")
	}
}

num=i-1
print("Number of ifuimages to combine is ",num)

#***** Read in the offsets
in=offsetfile
i=1
while(fscan(in,tempx,tempy)!=EOF){
	x[i]=tempx
	y[i]=tempy
	print("Got offset ",x[i],y[i])
	i+=1
	if(i>500){
		error(11,"You have more than 500 offset points but not that many ifu images!\nArray for offsets has run out of room!")
	}
}

if(num!=(i-1)){
	error(11,"List of images and list of offsets do not have the same number of points!")
}

#***** Read in the ifu configuration
#***** Assume table information in first image is the same as the rest of
#***** the list!
ifuconfigfile=mktemp("__ifuconfigfile__")
tprint(ifuimages[1]//"[1]",prparam-,prdata+,pwidth=80,plength=0,showrow-,
	orig_row-,showhdr-,columns="",rows="",option="plain",align-,
	sp_col="",lgroup=0,>ifuconfigfile)

in=ifuconfigfile
i=1
while(fscan(in,templens,tempx,tempy,tempap)!=EOF){
	if(tempx!=-999){
		lens[i]=templens
		gridx[i]=tempx
		gridy[i]=tempy
		apnum[i]=tempap
#		print("Got lens grid and ap ",lens[i],gridx[i],gridy[i],
#		       apnum[i])
		i+=1
		if(i>5000){
			error(11,"You have more than 5000 lenses in 1 IFU\nArray for lenses has run out of room!")
		}
	}
}

numlens=i-1

#***** Find out the size of the grid
mingridx=gridx[1]
maxgridx=gridx[1]
mingridy=gridy[1]
maxgridy=gridy[1]

for(i=1; i<=numlens; i+=1){
	if(gridx[i]<mingridx){
		mingridx=gridx[i]
	}
	if(gridx[i]>maxgridx){
		maxgridx=gridx[i]
	}
	if(gridy[i]<mingridy){
		mingridy=gridy[i]
	}
	if(gridy[i]>maxgridy){
		maxgridy=gridy[i]
	}
}

print("IFU grid size is: ",mingridx,"< x < ",maxgridx," ",
 	mingridy,"< y < ",maxgridy)

#***** Find out the extent of the offsetting
maxoffx=x[1]
minoffx=x[1]
maxoffy=y[1]
minoffy=y[1]

for(i=1; i<=num; i+=1){
	if(x[i]<minoffx){
		minoffx=x[i]
	}
	if(x[i]>maxoffx){
		maxoffx=x[i]
	}
	if(y[i]<minoffy){
		minoffy=y[i]
 	}
	if(y[i]>maxoffy){
		maxoffy=y[i]
	}
}

if(minoffx>0){
	minoffx=0
}

if(minoffy>0){
	minoffy=0
}

if(maxoffx<0){
	maxoffx=0
}

if(maxoffy<0){
	maxoffy=0
}

print("Max offsets are: ",minoffx,"x ",maxoffx, " ",
 	minoffy, "y ", maxoffy)

#***** Calculate the size of the new grid
newgridminx=mingridx-maxoffx
newgridmaxx=maxgridx-minoffx

newgridminy=mingridy-maxoffy
newgridmaxy=maxgridy-minoffy

print("New grid size is ",newgridminx,"< x < ",newgridmaxx," ",
 	newgridminy,"< y < ",newgridmaxy)

#***** Loop over the grid and add up the lenses
#***** Do this the easy way for a human to understand
#***** which is computationally bad!
lenscount=1
inlist=mktemp("__filelist__")
tempspec=mktemp("__tempspec__")
poslist=mktemp("__poslist__")
lenslist=mktemp("__lenslist__")
#tempscopy=mktemp("__scopy__")

print("scombining the spectra, this could take a while!")

for(i=newgridminx; i<=newgridmaxx; i+=1){

	for(j=newgridminy; j<=newgridmaxy; j+=1){

		gotalens=no
		
		count=1

		for(k=1; k<=num; k+=1){

			#***** Figure out which lenses to copy out
			lensx=i+x[k]
			lensy=j+y[k]
			
			#***** Find the spectrum corresponding 
			#***** to the lens in the IFU
			spectrum=-999
			
			for(h=1; h<=numlens; h+=1){

				if( (gridx[h]==lensx) && (gridy[h]==lensy)){
					
					spectrum=apnum[h]
					break
				
				}
			
			}
			
			if(spectrum!=-999){
	
# Attempt to fix random scopy behaviour that didn't work!
			        #scopy(ifuimages[k]//"[sci,1]", tempscopy//count, apertures=spectrum,verb+)

				#print(tempscopy//count,>>inlist)

				print(ifuimages[k]//"[sci,1][*,"//spectrum//"]", >>inlist)
					gotalens=yes
					count+=1
			}
		}
		
		if(gotalens){
	
			scombine("@"//inlist, 
				 output=tempspec//"_lens_"//lenscount,
                                 group="all",
				 >& "dev$null")
			print(lenscount,i,j,lenscount,>>poslist)
			print(tempspec//"_lens_"//lenscount,>>lenslist)
			lenscount+=1
                        #imdelete("@"//inlist)
			delete(inlist)
			
		}

	}

print("Done column ",i," of the mosaic")

}

lenscount-=1

#***** Make a temporary ms file
tempms=mktemp("__tempms__")
tempms=tempms//"ms.fits"

print("Making ",outfile)

# setting offset=0 here, causes the cl to print ambiguous parameter!!!!!
# This approach messes up the headers!!!!!!
#scopy("@"//lenslist, tempms, apertures="", bands="", beams="", apmodulus=0, 
#	format="multispec", renum+, clobber-, merge-, rebin+, verb-)
# back to the first approach .....

#scopy.offset=-1
#scopy("@"//lenslist, "ajd_test.ms", w1=INDEF, w2=INDEF, apertures="", 
#	bands="", beams="", apmodulus=0, format="multispec", renum+, 
#	clobber+, merge+, rebin+, verb-)

imgets(ifuimages//"[sci,1]", "i_naxis1")
specdim = int(imgets.value)

mkpattern(tempms,output="",pattern="constant",ndim=2,ncols=specdim,
	  nlines=lenscount)

print("Combined the spectra, making the ms file")
for(i=1; i<=lenscount; i+=1){
	imcopy(tempspec//"_lens_"//i,tempms//"[*,"//i//"]",verb-)
#	scopy(tempspec//"_lens_"//i,"ajdtest.ms",merge+,renum+,clobber+)
}


#***** Copy over the spectra into the output file

#***** The cheap and nasty solution again

#***** You really should fix this section !!!!!

makemef3(ifuimages[1],tempms, outfile)
fxdelete(outfile,groups="1",verb-)

#***** Reduce nextend by 1 as have removed an extension
nextend=0
hselect(outfile//"[0]","NEXTEND",yes) | scan(nextend)
nextend=nextend-1
hedit(outfile//"[0]",fields="NEXTEND", value=nextend, add-, update+, ver-, show-)

# insert_table knows our lenses are hexagons !!!!!
insert_table(outfile,poslist) 

#makemef2(ifuimages[1],"ajd_test.ms.fits","ajd_test_wav.ms.fits")
#fxdelete("ajd_test_wav.ms.fits",groups="1",verb-)
#insert_table("ajd_test_wav.ms.fits",poslist) 

#***** Clean up
delete(tempspec//"_lens_*")
delete(ifuconfigfile)
delete(poslist)
delete(lenslist)
delete(tempms)

end










