
/* C Program to read in data from a file and then fit the data to a
** straight line, returning the intercept, gradient and chi squared
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "nrroutines.h"
#include "cpgplot.h"      /* for the graphics output */

int main(int argc, char* argv[])
{

  /* Initialise all the variables */
  float mean[2000]={0},  variance[2000]={0};
  float a, b, siga, sigb, chi2, q;
  float sig[2000]={0};
  float fitx[2]={0};
  float fity[2]={0};
  float xminval=0;
  float xmaxval=0;
  float yminval=0;
  float ymaxval=0;
  char title[100];
  
  int mwt=0;
  int n=1;

  int num;
  char pm=(char)177; /* The plus / minus symbol */
  char* outputdevice=NULL;       /* output device */

  FILE* datain;

  printf("\n Program reads in mean and variance and finds \n the gradient and intercept for x=mean, y=variance plot\n\n"); 

  if ( argc < 2 ){
   
    printf("Usage: %s datafile [output.ps]\n", argv[0]);
    exit(1);
    
  }
 
  if ( argc == 3 ){
 
    if ( (outputdevice=(char *)malloc((strlen(argv[2])+4)*sizeof(char))) 
	 == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice,argv[2]);
    strcat(outputdevice,"/PS");
    
  } else if ( argc == 2 ){
    
    if ( (outputdevice=(char *)malloc(9*sizeof(char))) == NULL ){
      
      printf("plot: memory allocation for output file failed\n");
      exit(1);
      
    }
    
    strcpy(outputdevice, "/xwindow");
   
  }

  /* Read in the data */
  if ( !(datain = fopen(argv[1],"r")) ){
    
    printf("Failed to open the input data file\n");
    exit(1);
  }

  n=1;   /* Fit expects arrays starting at 1 -> N */

  while ( fscanf(datain,"%f %f",(mean+n),(variance+n)) !=EOF ){
    
    printf(" %f\t%f\n",*(mean+n),*(variance+n));
    n+=1;
    if( n>=2000 ){
      printf("Too many data points in file.\n Limit is currently 2000.\n") ;
      exit (1);
    }
    
  }
    
  fclose(datain); 
 
  num=n-1;
  
  printf("\n File contains %i data points\n",num);

  /* Fit them to a straight line and return the intercept and gradient */
  fit(mean, variance, num, sig, mwt, &a, &b, &siga, &sigb, &chi2, &q);
 
  printf("\n Gradient = %f\n Intercept = %f\n",b,a);
 
  printf("\n Gain = %f %c %f electrons / DN\n Read Noise = %f electrons / read\n", 1/(b), pm, (1/(b))*(sigb)/(b), sqrt((1/(b))*(a)));
 
  printf("\n Chi-Squared = %f\n\n", chi2);

  /* Make up a straight line graph of the fit */
  xminval=*(mean+1)*0.85;
  xmaxval=*(mean+num)*1.15;
  yminval=*(variance+1)*0.85;
  ymaxval=*(variance+num)*1.15;
  
  fitx[0]=xminval;
  fity[0]=a+b*fitx[0];
  fitx[1]=xmaxval;
  fity[1]=a+b*fitx[1];

  /* Plot the data in a graph */
  /* Open graphics device. */      
  if(cpgbeg(0, outputdevice, 1, 1) != 1)
    return 1; 

  /* Plot the output on screen */
  /* Define coordinate range of graph and draw axes. */
  cpgenv(xminval, xmaxval, yminval, ymaxval, 0, 0);

  sprintf(title,"Gain = %f %c %f e/DN, Read noise = %f", 1/(b), pm, 
	  (1/(b))*(sigb)/(b), sqrt((1/(b))*(a)));
  
  /* Label the axes */
  cpglab("Mean", "Variance", title);
  
  /*  Plot the line graph. */
  cpgsci(5); /* Blue lines */
  cpgline(2, fitx, fity);
  
  cpgsci(1); /* White points */
  cpgpt(num,(mean+1),(variance+1),5);

  /* Close the graphics device */
  cpgend();

  free (outputdevice);
 
  return 0;
  
}








