#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include "extract.h"
#include "fitswrap.h"

/*this program to write out a simulated CIRPASS image. was doing this
  with IRAF mk2dspec routine, but I don't think that is accurate enough*/

int main ()
{
  double *phi[499];
  double data[2048]={0};
  double peakpos[499];
  double fibval[499];
  char* exts[]={"SCI"};
  char outfile[255];
  char filename[255];
  char templfile[255];
  int numpk, numval, i, j, type;
  int naxis=2;
  long naxes[]={2048,2048};
  double *outdata[1];
  int cnt=0;
 
  outdata[0] = (double*) malloc((sizeof(double))*2048*2048);

  for(i=0;i<499;i++){
    phi[i]=(double*)malloc(2048*sizeof(double));
  }

  printf("what is the name for the output FITS image?\n");
  scanf("%s",outfile);

  /*template file for header and table extension*/
  sprintf(templfile,"templ.fits");

  /*read coordinates of peaks from file */
  sprintf(filename,"peakpos.list");
  numpk = getval1(filename, peakpos, 499);

  /*read sum in each fibre from file */
  sprintf(filename,"fibval.list");
  numval = getval1(filename,fibval,499);

  /*for(i=0;i<numpk;i++){
    printf("fibval %g\n",fibval[i]);
    }*/

  type=gettype();
  printf("type %d\n",type);

  /*get phi values.*/
  getphi(peakpos, numpk, 2048, type, phi);
  printf("after getphi\n");

  i=0;
  for(j=0;j<2048;j++){
    if((j>521)&&(j<530)){
      printf("i %d j %d phi %g\n",i,j,phi[i][j]);
    }
  }
  /*work out data value at each pixel row i column j*/
  /*for now just need to work out one column as all the columns are the same*/

  printf("working out data values\n");
  for(j=0;j<2048;j++){
    for(i=0;i<numpk;i++){
      /*      if((j>521)&&(j<530)){
	printf("i %d j %d data %g\n",i,j,data[j]);
	}*/
      data[j]+=phi[i][j]*fibval[i];
      /*
      if((j>521)&&(j<530)){
	printf("i %d j %d phi %g fibval %g data %g\n",i,j,phi[i][j],fibval[i],data[j]);
	}*/
    }
  }

  printf("creating output array\n");
  for(i=0;i<2048;i++){
    for(j=0;j<2048;j++){
      outdata[0][j*2048+i]=data[j];
      cnt++;
    }
  }

  /*write out data to FITS file*/
  printf("writing output FITS file\n");
  /*writefits_double_basic(outfile,naxes,outdata);*/
  printf("naxis %d naxes %d cnt %d\n",naxis,*naxes,cnt);

  /*this isn't working at the moment, complains about FITS file being
    too big*/
  write_cirp_copy_hdu(templfile,outfile,exts,outdata,1,naxis,naxes);

  for(i=0;i<499;i++){
    free(phi[i]);
  }


  free(outdata[0]);
    

  return 0;
}
