# iraf script to generate an oh mask from a pipeline generated
# cirpass MEF file, producing a MEF file out
#
# A. J. Dean 15th April, 2002.

procedure ohmask(infile, outmaskfile, threshold)

string infile {prompt="Input file containing oh lines"}
string outmaskfile {prompt="Output file to contain OH mask"}
real threshold {prompt="Pixel value above which it's an OH line"}

begin

string filein, maskfile, tempfile
real thresh
int len

filein = infile
maskfile = outmaskfile
thresh = threshold

# load required packages
if (!defpac ("stsdas")) {stsdas}	
if (!defpac ("toolbox")) {toolbox}	
if (!defpac ("imgtools")) {imgtools}	

tempfile=mktemp("__tempfile__")
tempfile=tempfile//".fits"

len=strlen(filein)
        if(substr(filein,len-4,len)!=".fits") {
                filein=filein//".fits"
        }


len=strlen(maskfile)
        if(substr(maskfile,len-4,len)!=".fits") {
                maskfile=maskfile//".fits"
        }


imcalc(filein//"[sci,1]", tempfile, "if im1 < "//thresh//" then 1.0 else 0.0",pixtype="int")

makemef(filein,tempfile,maskfile)

delete(tempfile)

end

