###############################################################################
# Data reduction pipeline for Cirpass using broken 2k win98 PixCel 
# Works on raw data output by PixCel which is _not_ mosaiced and contains
# all the correct keywords.
#
# Created by AJD 10 Sep 2001
##############################################################################

procedure docirpass(name,run_no,dateobs,stackno)

string name {prompt="Root name"}
string run_no {prompt="Run no."}
string dateobs {prompt="Date of observations"}
string stackno {prompt="Stack the n'th read of every loop, or all"}
string createdir {prompt="Should I create it (y/n)?"}
string configfile {"/home/cirpass/IFUdat/cohsi.cfg", prompt="File containing IFU fibre configuration info"}

struct *in {mode="h"}

begin

struct logicvals
string fname,frunno,fdateobs,fstackno
string rawdir,reddir,file1,rawfile,stackout,readno,tempfile,outfile
string tempfile1,stackph
string zoffcorr,maskcorr,noiscalc,timecalc,lincorr,unitcorr,bkgcorr
string doextr,dowvcal,dowvalgn,flatcorr,doflcal,cridcalc
string maskfile,noisfile,linfile,bkgfile,extrfile,wvfile,flatfile,calfile
string dbfile, imaout,imaoutroot,imaph,ans, cfgfile
string sciname,tempstr
real gain,readnoise
int nexn,len,beg,nloops,nreads,ifstackno,totnum,inc,junk
bool rawexist,redexist,stackexist,rawdatexist
bool zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc
bool extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc,datred

#########################query parameters#####################################
#except stack no
fname=name
frunno=run_no
fdateobs=dateobs
cfgfile=configfile

########################constant variables####################################
#set in cirpasspars.par
nexn=cirpasspars.nexn
sciname=cirpasspars.sciname

##########################set up procedures####################################
##load required packages
utils
fitsutil

##find names of raw and pipeline reduced data directory
##these env variables are currently set in cirpass.cl
transenv("cirpraw") | scan(rawdir)
transenv("cirpred") | scan(reddir)
##if these don't end in / then add one
len=strlen(rawdir)
if(substr(rawdir,len,len)!="/")
  rawdir=rawdir//"/"
len=strlen(reddir)
if(substr(reddir,len,len)!="/")
  reddir=reddir//"/"

rawdir=rawdir//fdateobs
reddir=reddir//fdateobs

##check these directories exist
rawexist=yes
if(!access(rawdir))
  rawexist=no

redexist=yes
if(!access(reddir))
  redexist=no

##if pipeline reduced directory doesn't exist then offer
##to create it. If not created then stop
if(!redexist){
  print("Pipeline reduction directory ",reddir," doesn't exist")
  ans=createdir
  if(ans=="y"){
    mkdir(reddir)
  }
  else{
    error(11,"Pipeline reduction directory "//reddir//" not found")
  }
}

##add / to raw and reduced
##do this after checking it exists otherwise check doesnt work
rawdir=rawdir//"/"
reddir=reddir//"/"
print("Raw data directory ",rawdir)
print("Reduced data directory ",reddir)

## Sort out the PixCel run numbering scheme
## eg run 1 is numbered run 0001
## run nos should be 1-9999
    frunno="000"//frunno
    len=strlen(frunno)
    beg=len-3
    frunno=substr(frunno,beg,len)

## AJD addition from docirpass -> sort out the mosaicing

file1=rawdir//fname//"_"//frunno//"_c1q1_000.fits"
if(access(file1)){
  hselect(file1,"nloops",yes) | scan(nloops)
  hselect(file1,"nreads",yes) | scan(nreads)
  print("Loops ",nloops," Reads ",nreads)
  fstackno=stackno
  print("Mosaicing the raw files")
  mosaic(file1)	
} else {

########printing no of loops and reads in this data#######################
##have to get this info from a raw file as don't know what other files exist 
##yet. nloops and nreads found here to remind user before they
##decide which to stack (used later also). 
##they may not do any stacking anyway if stacked
##file exists already, so don't stop if the raw data file doesn't exist
  file1=rawdir//fname//"_"//frunno//"_c1_000.fits"
  print("file1 ",file1)
  if(access(file1)){
    hselect(file1,"nloops",yes) | scan(nloops)
    hselect(file1,"nreads",yes) | scan(nreads)
    print("Loops ",nloops," Reads ",nreads)
  }
  fstackno=stackno 
}

##query parameter stackno
#AJD moved above!
#fstackno=stackno
if(fstackno!="all"){
  ifstackno=int(fstackno)

##check that the number asked for makes sense
  while(ifstackno>nreads){
    print("Only "//nreads//" reads per loop and you asked me to stack read number "//fstackno)
  fstackno=stackno
  ifstackno=int(fstackno)
  }

}
else{
  ifstackno=1
}

########check if stacked files already exist######################
rawexist=yes
stackexist=yes
##stacked files

stackout=reddir//fname//"_"//frunno//"_raw.fits"

if(!access(stackout))
  stackexist=no

##if stacked file doesn't exist then worry about whether the raw data exists
if(!stackexist){
  print("Stack file ",stackout," doesn't exist")
##if raw data directory doesn't exist then stop
  if(!rawexist)
    error(10,"Stacked file doesn't exist and raw data directory doesn't exist so can't create _raw file")

##check that all raw data exists
##set rawdatexist=no if not all of them exist
##can't do anything unless they all exist
##raw files have the form name_runno_c1_00#.fits
##file1 is the name of the raw first read (defined it already above)
##if this doesn't exist then not all raw files exist so rawdatexist is no
  rawdatexist=yes
  if(!access(file1)){
    rawdatexist=no
  }
##if this does exist, then already know nloops and nreads from above
##check that all the required raw files exist
  else{
##work out total number of reads (= total number of raw files) from
##nloops and nreads
    totnum=(nloops+1)*nreads;
    print("Total number of reads ",totnum)
    for(i=0;i<totnum;i+=1){
      print("i ",i)
      readno="00"//i
      len=strlen(readno)
      beg=len-2
      readno=substr(readno,beg,len)
      rawfile=rawdir//fname//"_"//frunno//"_c1_"//readno//".fits"
      print("rawfile ",rawfile)
      if(!access(rawfile))
        rawdatexist=no
    }
  }
##if raw files don't exist and stack file
##doesn't exist then stop as can't read raw data to make stacked file
  if(!rawdatexist)
    error(10,"Raw data and stacked _raw file don't exist so can't do anything")

#########################stacking##############################################
##still in if(!stackexist)
##if there is no stack file then make one
##run stack_read
##create output file

##create temp file containing list of files to be stacked
  tempfile=mktemp("temp")
  print("tempfile ",tempfile)
##do this with a loop to get the correct order
  print("Stacking files")
  if(fstackno=="all"){
    inc=1;
  }
  else{
    inc=nreads;
  }
  for(i=ifstackno-1;i<totnum;i+=inc){     
      readno="00"//i
      len=strlen(readno)
      beg=len-2
      readno=substr(readno,beg,len)
      outfile=rawdir//fname//"_"//frunno//"_c1_"//readno//".fits"
      print(outfile)
      print(outfile,>>tempfile)
  }
##stackout is output stacked file

  stackout=reddir//fname//"_"//frunno//"_raw.fits"
  print("Running stack_read. Output file is ",stackout)

##do stacking
  tempfile1="@"//tempfile
  stack_read(tempfile1,stackout,cfgfile)

##delete tempfile
  delete(tempfile)

}
##end of if(!stackexist)
else{
  print("Stack file ",stackout," exists")
}
stackph=stackout//"[0]"

##tasks after here should use nextend keyword and nexn parameter to
##work out the number of imsets.

##############get data reduction keywords from header#########################
print("Reading data reduction keywords from header ",stackph)
##annoyingly have to set all variables to something before can read
##correct value into them using scan. otherwise it complains about
##undefined variables
zoffcorr="notset"
maskcorr="notset"
noiscalc="notset"
timecalc="notset"
lincorr="notset"
unitcorr="notset"
bkgcorr="notset"
doextr="notset"
dowvcal="notset"
dowvalgn="notset"
flatcorr="notset"
doflcal="notset"
cridcalc="notset"
maskfile="notset"
noisfile="notset"
linfile="notset"
bkgfile="notset"
extrfile="notset"
dbfile="notset"
wvfile="notset"
flatfile="notset"
calfile="notset"

hselect(stackph,"zoffcorr",yes) | scan(zoffcorr)
hselect(stackph,"maskcorr",yes) | scan(maskcorr)
hselect(stackph,"noiscalc",yes) | scan(noiscalc)
hselect(stackph,"timecalc",yes) | scan(timecalc)
hselect(stackph,"lincorr",yes) | scan(lincorr)
hselect(stackph,"unitcorr",yes) | scan(unitcorr)
hselect(stackph,"bkgcorr",yes) | scan(bkgcorr)
hselect(stackph,"doextr",yes) | scan(doextr)
hselect(stackph,"dowvcal",yes) | scan(dowvcal)
hselect(stackph,"dowvalgn",yes) | scan(dowvalgn)
hselect(stackph,"flatcorr",yes) | scan(flatcorr)
hselect(stackph,"doflcal",yes) | scan(doflcal)
hselect(stackph,"cridcalc",yes) | scan(cridcalc)
hselect(stackph,"maskfile",yes) | scan(maskfile)
hselect(stackph,"noisfile",yes) | scan(noisfile)
hselect(stackph,"linfile",yes) | scan(linfile)
hselect(stackph,"bkgfile",yes) | scan(bkgfile)
hselect(stackph,"extrfile",yes) | scan(extrfile)
hselect(stackph,"dbfile",yes) | scan(dbfile)
hselect(stackph,"wvfile",yes) | scan(wvfile)
hselect(stackph,"flatfile",yes) | scan(flatfile)
hselect(stackph,"calfile",yes) | scan(calfile)

hselect(stackph,"gain",yes) | scan(gain)
hselect(stackph,"readnois",yes) | scan(readnoise)

##############check logic of data reduction keywords##########################
##add following parameters=yes to _logic_check to check logic. 
##zoffchk=no,maskchk=no,noischk=no,timechk=no,linchk=no,unitchk=no,cridchk=no
##Not all of these steps need any logic checking.
##_logic_check only checks logic if corresponding lgc parameter (which
##it finds) is yes

print("Checking logic of required data reduction steps\n");

_logic_check(targetname=stackout,nexn=nexn,zoffcorr=zoffcorr,maskcorr=maskcorr,noiscalc=noiscalc,timecalc=timecalc,lincorr=lincorr,unitcorr=unitcorr,cridcalc=cridcalc,bkgcorr=bkgcorr,doextr=doextr,dowvcal=dowvcal,dowvalgn=dowvalgn,flatcorr=flatcorr,doflcal=doflcal,maskfile=maskfile,noisfile=noisfile,linfile=linfile,bkgfile=bkgfile,extrfile=extrfile,wvfile=wvfile,flatfile=flatfile,calfile=calfile,zoffchk=yes,maskchk=yes,noischk=yes,timechk=yes,linchk=yes,unitchk=yes,cridchk=yes)

##output from _logic_check is struct containing final lgc parameter values
logicvals=_logic_check.outlogic
junk=fscan(logicvals,zofflgc,masklgc,noislgc,timelgc,linlgc,unitlgc,cridlgc,bkglgc,extrlgc,wvcallgc,wvalgnlgc,flatlgc,flcallgc)

##create final datred logical value
datred=(zofflgc) || (masklgc) || (noislgc) || (timelgc) || (linlgc) || (unitlgc) || (cridlgc) || (masklgc) || (noislgc) || (linlgc)

###############################################################################
###################create output file##########################################
##This goes into current directory
##filename is name_run_ima.inc.fits where inc is a number which
##increments with each run of doschmidt on the same raw data from
##the same directory
imaoutroot=fname//"_"//frunno//"_ima"
imaout=fname//"_"//frunno//"_ima.fits"

inc=1
while(access(imaout)){
  imaout=imaoutroot//"."//inc//".fits"
  inc+=1
}
print("DOCIRPASS: Creating ",imaout)
#copy(stackout,imaout,verb-)
fxcopy(stackout,imaout,groups="",new_file+)
imaph=imaout//"[0]"

##################run data reduction tasks#####################################
##run lincorr if lincorr=perform
if(linlgc){
  print("Running lincorr")
  lincorr(imaout)
  hedit(imaph,"LINDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"LINDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run zerosub if zofflgc
if(zofflgc){
  print("Running zerosub")
  zsub(imaout)
##change keyword zoffdone to performed
  hedit(imaph,"ZOFFDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"ZOFFDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run badmask if masklgc
if(masklgc){
  print("Running badmask")
  print("Sorry badmask isn't written yet")
  hedit(imaph,"MASKDONE","OMITTED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"MASKDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run mkerr if noislgc
if(noislgc){
  print("Running mkerr")
  mkerr(imaout,readnoise,gain)
  hedit(imaph,"NOISDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"NOISDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run mktime if timelgc
if(timelgc){
  print("Running mktime")
  print("Sorry mktime isn't written yet")
  hedit(imaph,"TIMEDONE","OMITTED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"TIMEDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run ctrate is unitlgc
if(unitlgc){
  print("Running ctrate")
  print("Sorry ctrate isn't written yet")
  hedit(imaph,"UNITDONE","OMITTED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"UNITDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##run cosmic if cridlgc
if(cridlgc){
  print("Running cosmic")
  cosmic(imaout)
  hedit(imaph,"CRIDDONE","PERFORMED",add-,delete-,verify-,show-,update+)
}
else{
  hedit(imaph,"CRIDDONE","OMITTED",add-,delete-,verify-,show-,update+)
}

##change CALSTAGE to be docirpass
hedit(imaph,"CALSTAGE","docirpass",add-,delete-,verify-,show-,update+)
#########################end of data reduction#################################

#########################show results##########################################
##if you've done any imaibration then display the final science image
##from the _ima file

if(datred){
  display(imaout//"["//sciname//",1]",1)
}
###############################################################################

#########################tidy up###############################################
##increment the run no at the end so it's set for the next run
run_no=frunno+1
###############################################################################

end
